/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.Mutils;
import io.muserver.ParameterizedHeaderWithValue;
import io.muserver.rest.MuRuntimeDelegate;
import jakarta.ws.rs.core.MediaType;
import java.util.List;

public class MediaTypeParser {
    public static MediaType fromString(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        List<ParameterizedHeaderWithValue> headerValues = ParameterizedHeaderWithValue.fromString(value);
        if (headerValues.isEmpty()) {
            throw new IllegalArgumentException("The value '" + value + "' did not contain a valid header value");
        }
        ParameterizedHeaderWithValue v = headerValues.get(0);
        String[] split = v.value().split("/");
        if (split.length != 2) {
            throw new IllegalArgumentException("Media types must be in the format 'type/subtype'; this is inavlid: '" + v.value() + "'");
        }
        return new MediaType(split[0], split[1], v.parameters());
    }

    public static String toString(MediaType mediaType) {
        Mutils.notNull("mediaType", mediaType);
        return new ParameterizedHeaderWithValue(mediaType.getType() + "/" + mediaType.getSubtype(), mediaType.getParameters()).toString();
    }

    static {
        MuRuntimeDelegate.ensureSet();
    }
}

