/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.HeaderNames;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;

class MuGzipHttp2ConnectionEncoder
implements Http2ConnectionEncoder {
    private final Http2ConnectionEncoder encoder;

    MuGzipHttp2ConnectionEncoder(Http2ConnectionEncoder encoder) {
        this.encoder = encoder;
    }

    public void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        this.encoder.lifecycleManager(lifecycleManager);
    }

    public Http2Connection connection() {
        return this.encoder.connection();
    }

    public Http2RemoteFlowController flowController() {
        return this.encoder.flowController();
    }

    public Http2FrameWriter frameWriter() {
        return this.encoder.frameWriter();
    }

    public Http2Settings pollSentSettings() {
        return this.encoder.pollSentSettings();
    }

    public void remoteSettings(Http2Settings settings) throws Http2Exception {
        this.encoder.remoteSettings(settings);
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        this.fixEncoding(headers);
        return this.encoder.writeHeaders(ctx, streamId, headers, padding, endStream, promise);
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream, ChannelPromise promise) {
        this.fixEncoding(headers);
        return this.encoder.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream, promise);
    }

    private void fixEncoding(Http2Headers headers) {
        CharSequence seq = (CharSequence)headers.get((Object)HeaderNames.CONTENT_ENCODING);
        CharSequence actual = MuGzipHttp2ConnectionEncoder.actualEncodingIfHasMuPrefix(seq);
        if (actual != null) {
            headers.set((Object)HeaderNames.CONTENT_ENCODING, (Object)actual);
        }
    }

    static CharSequence actualEncodingIfHasMuPrefix(CharSequence seq) {
        int len;
        if (seq != null && (len = seq.length()) > 3 && seq.charAt(0) == 'm' && seq.charAt(1) == 'u' && seq.charAt(2) == '-') {
            return seq.subSequence(3, len);
        }
        return null;
    }

    public ChannelFuture writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        return this.encoder.writePriority(ctx, streamId, streamDependency, weight, exclusive, promise);
    }

    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        return this.encoder.writeRstStream(ctx, streamId, errorCode, promise);
    }

    public ChannelFuture writeSettings(ChannelHandlerContext ctx, Http2Settings settings, ChannelPromise promise) {
        return this.encoder.writeSettings(ctx, settings, promise);
    }

    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
        return this.encoder.writeSettingsAck(ctx, promise);
    }

    public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
        return this.encoder.writePing(ctx, ack, data, promise);
    }

    public ChannelFuture writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding, ChannelPromise promise) {
        return this.encoder.writePushPromise(ctx, streamId, promisedStreamId, headers, padding, promise);
    }

    public ChannelFuture writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        return this.encoder.writeGoAway(ctx, lastStreamId, errorCode, debugData, promise);
    }

    public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
        return this.encoder.writeWindowUpdate(ctx, streamId, windowSizeIncrement, promise);
    }

    public ChannelFuture writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload, ChannelPromise promise) {
        return this.encoder.writeFrame(ctx, frameType, streamId, flags, payload, promise);
    }

    public Http2FrameWriter.Configuration configuration() {
        return this.encoder.configuration();
    }

    public void close() {
        this.encoder.close();
    }

    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream, ChannelPromise promise) {
        return this.encoder.writeData(ctx, streamId, data, padding, endStream, promise);
    }
}

