/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.HttpConnection;
import io.muserver.HttpsConfigBuilder;
import io.muserver.MuStats;
import io.muserver.RateLimiter;
import io.muserver.SSLInfo;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface MuServer {
    default public void stop() {
        this.stop(0L, TimeUnit.MILLISECONDS);
    }

    public boolean stop(long var1, TimeUnit var3);

    public URI uri();

    public URI httpUri();

    public URI httpsUri();

    public MuStats stats();

    public Set<HttpConnection> activeConnections();

    public InetSocketAddress address();

    public static String artifactVersion() {
        try {
            Properties props = new Properties();
            InputStream in = MuServer.class.getResourceAsStream("/META-INF/maven/io.muserver/mu-server/pom.properties");
            if (in == null) {
                return "0.x";
            }
            try {
                props.load(in);
            }
            finally {
                in.close();
            }
            return props.getProperty("version");
        }
        catch (Exception ex) {
            return "0.x";
        }
    }

    public long minimumGzipSize();

    public int maxRequestHeadersSize();

    public long requestIdleTimeoutMillis();

    public long maxRequestSize();

    public int maxUrlSize();

    public boolean gzipEnabled();

    public Set<String> mimeTypesToGzip();

    public void changeHttpsConfig(HttpsConfigBuilder var1);

    public SSLInfo sslInfo();

    public List<RateLimiter> rateLimiters();
}

