/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.AlpnHandler;
import io.muserver.BackPressureHandler;
import io.muserver.Http1Connection;
import io.muserver.Http2Config;
import io.muserver.Http2ConfigBuilder;
import io.muserver.HttpsConfigBuilder;
import io.muserver.Method;
import io.muserver.MuException;
import io.muserver.MuHandler;
import io.muserver.MuHandlerBuilder;
import io.muserver.MuServer;
import io.muserver.MuServerImpl;
import io.muserver.MuStatsImpl;
import io.muserver.Mutils;
import io.muserver.NettyHandlerAdapter;
import io.muserver.NettyResponseAdaptor;
import io.muserver.PreReader;
import io.muserver.RateLimitSelector;
import io.muserver.RateLimiter;
import io.muserver.RateLimiterImpl;
import io.muserver.ResponseCompleteListener;
import io.muserver.RouteHandler;
import io.muserver.Routes;
import io.muserver.SSLInfoImpl;
import io.muserver.SelectiveHttpContentCompressor;
import io.muserver.ServerSettings;
import io.muserver.SslContextProvider;
import io.muserver.UnhandledExceptionHandler;
import io.muserver.handlers.ResourceType;
import io.muserver.rest.MuRuntimeDelegate;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuServerBuilder {
    private static final Logger log;
    private static final int LENGTH_OF_METHOD_AND_PROTOCOL = 17;
    private static final int DEFAULT_NIO_THREADS;
    private long minimumGzipSize = 1400L;
    private int httpPort = -1;
    private int httpsPort = -1;
    private int maxHeadersSize = 8192;
    private int maxUrlSize = 8175;
    private int nioThreads = DEFAULT_NIO_THREADS;
    private final List<MuHandler> handlers = new ArrayList<MuHandler>();
    private boolean gzipEnabled = true;
    private Set<String> mimeTypesToGzip = ResourceType.gzippableMimeTypes(ResourceType.getResourceTypes());
    private boolean addShutdownHook = false;
    private String host;
    private HttpsConfigBuilder sslContextBuilder;
    private Http2Config http2Config;
    private long requestReadTimeoutMillis = TimeUnit.MINUTES.toMillis(2L);
    private long idleTimeoutMills = TimeUnit.MINUTES.toMillis(10L);
    private ExecutorService executor;
    private long maxRequestSize = 0x1800000L;
    private List<ResponseCompleteListener> responseCompleteListeners;
    private HashedWheelTimer wheelTimer;
    private List<RateLimiterImpl> rateLimiters;
    private WriteBufferWaterMark writeBufferWaterMark = WriteBufferWaterMark.DEFAULT;
    private UnhandledExceptionHandler unhandledExceptionHandler;
    private boolean haProxyProtocolEnabled = false;

    public MuServerBuilder withHttpPort(int port) {
        this.httpPort = port;
        return this;
    }

    public MuServerBuilder withInterface(String host) {
        this.host = host;
        return this;
    }

    public MuServerBuilder addShutdownHook(boolean stopServerOnShutdown) {
        this.addShutdownHook = stopServerOnShutdown;
        return this;
    }

    public MuServerBuilder withGzipEnabled(boolean enabled) {
        this.gzipEnabled = enabled;
        return this;
    }

    public MuServerBuilder withGzip(long minimumGzipSize, Set<String> mimeTypesToGzip) {
        this.gzipEnabled = true;
        this.mimeTypesToGzip = mimeTypesToGzip;
        this.minimumGzipSize = minimumGzipSize;
        return this;
    }

    public MuServerBuilder withHttpsConfig(HttpsConfigBuilder httpsConfig) {
        this.sslContextBuilder = httpsConfig;
        return this;
    }

    public MuServerBuilder withHttpsPort(int port) {
        this.httpsPort = port;
        return this;
    }

    public MuServerBuilder withHttp2Config(Http2Config http2Config) {
        this.http2Config = http2Config;
        return this;
    }

    public MuServerBuilder withHttp2Config(Http2ConfigBuilder http2Config) {
        return this.withHttp2Config(http2Config.build());
    }

    public MuServerBuilder withHandlerExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public MuServerBuilder withNioThreads(int nioThreads) {
        this.nioThreads = nioThreads;
        return this;
    }

    public MuServerBuilder withMaxHeadersSize(int size) {
        this.maxHeadersSize = size;
        return this;
    }

    public MuServerBuilder withMaxUrlSize(int size) {
        this.maxUrlSize = size;
        return this;
    }

    public MuServerBuilder withMaxRequestSize(long maxSizeInBytes) {
        this.maxRequestSize = maxSizeInBytes;
        return this;
    }

    public MuServerBuilder withIdleTimeout(long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("The duration must be 0 or greater");
        }
        Mutils.notNull("unit", (Object)unit);
        this.idleTimeoutMills = unit.toMillis(duration);
        return this;
    }

    public MuServerBuilder withRequestTimeout(long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("The duration must be 0 or greater");
        }
        Mutils.notNull("unit", (Object)unit);
        this.requestReadTimeoutMillis = unit.toMillis(duration);
        return this;
    }

    public MuServerBuilder addHandler(MuHandlerBuilder handler) {
        if (handler == null) {
            return this;
        }
        return this.addHandler((MuHandler)handler.build());
    }

    public MuServerBuilder addHandler(MuHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
        return this;
    }

    public MuServerBuilder addHandler(Method method, String uriTemplate, RouteHandler handler) {
        if (handler == null) {
            return this;
        }
        return this.addHandler(Routes.route(method, uriTemplate, handler));
    }

    public MuServerBuilder addResponseCompleteListener(ResponseCompleteListener listener) {
        if (listener != null) {
            if (this.responseCompleteListeners == null) {
                this.responseCompleteListeners = new ArrayList<ResponseCompleteListener>();
            }
            this.responseCompleteListeners.add(listener);
        }
        return this;
    }

    MuServerBuilder withWriteBufferWaterMark(int low, int high) {
        this.writeBufferWaterMark = new WriteBufferWaterMark(low, high);
        return this;
    }

    public MuServerBuilder withRateLimiter(RateLimitSelector selector) {
        if (this.wheelTimer == null) {
            this.wheelTimer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("mu-limit-timer"));
            this.wheelTimer.start();
            this.rateLimiters = new ArrayList<RateLimiterImpl>();
        }
        RateLimiterImpl rateLimiter = new RateLimiterImpl(selector, this.wheelTimer);
        this.rateLimiters.add(rateLimiter);
        return this;
    }

    public MuServerBuilder withExceptionHandler(UnhandledExceptionHandler exceptionHandler) {
        this.unhandledExceptionHandler = exceptionHandler;
        return this;
    }

    public long minimumGzipSize() {
        return this.minimumGzipSize;
    }

    public int httpPort() {
        return this.httpPort;
    }

    public int httpsPort() {
        return this.httpsPort;
    }

    public int maxHeadersSize() {
        return this.maxHeadersSize;
    }

    public int maxUrlSize() {
        return this.maxUrlSize;
    }

    public int nioThreads() {
        return this.nioThreads;
    }

    public List<MuHandler> handlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public boolean gzipEnabled() {
        return this.gzipEnabled;
    }

    public Set<String> mimeTypesToGzip() {
        return Collections.unmodifiableSet(this.mimeTypesToGzip);
    }

    public boolean addShutdownHook() {
        return this.addShutdownHook;
    }

    public String interfaceHost() {
        return this.host;
    }

    public HttpsConfigBuilder httpsConfigBuilder() {
        if (this.sslContextBuilder != null && !(this.sslContextBuilder instanceof HttpsConfigBuilder)) {
            throw new IllegalStateException("Please switch to using HttpsConfigBuilder to set HTTPS config");
        }
        return this.sslContextBuilder;
    }

    public Http2Config http2Config() {
        return this.http2Config;
    }

    public long requestReadTimeoutMillis() {
        return this.requestReadTimeoutMillis;
    }

    public long idleTimeoutMills() {
        return this.idleTimeoutMills;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public long maxRequestSize() {
        return this.maxRequestSize;
    }

    public boolean haProxyProtocolEnabled() {
        return this.haProxyProtocolEnabled;
    }

    public List<ResponseCompleteListener> responseCompleteListeners() {
        return Collections.unmodifiableList(this.responseCompleteListeners);
    }

    public List<RateLimiter> rateLimiters() {
        return this.rateLimiters.stream().map(RateLimiter.class::cast).collect(Collectors.toList());
    }

    public UnhandledExceptionHandler unhandledExceptionHandler() {
        return this.unhandledExceptionHandler;
    }

    public static MuServerBuilder muServer() {
        return new MuServerBuilder();
    }

    public static MuServerBuilder httpServer() {
        return MuServerBuilder.muServer().withHttpPort(0);
    }

    public static MuServerBuilder httpsServer() {
        return MuServerBuilder.muServer().withHttpsPort(0);
    }

    public MuServerBuilder withHAProxyProtocolEnabled(boolean enabled) {
        this.haProxyProtocolEnabled = enabled;
        return this;
    }

    public MuServer start() {
        if (this.httpPort < 0 && this.httpsPort < 0) {
            throw new IllegalArgumentException("No ports were configured. Please call MuServerBuilder.withHttpPort(int) or MuServerBuilder.withHttpsPort(int)");
        }
        ServerSettings settings = new ServerSettings(this.minimumGzipSize, this.maxHeadersSize, this.requestReadTimeoutMillis, this.maxRequestSize, this.maxUrlSize, this.gzipEnabled, this.mimeTypesToGzip, this.rateLimiters);
        ExecutorService handlerExecutor = this.executor;
        if (handlerExecutor == null) {
            DefaultThreadFactory threadFactory = new DefaultThreadFactory("muhandler");
            handlerExecutor = new ThreadPoolExecutor(8, 400, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
        }
        NettyHandlerAdapter nettyHandlerAdapter = new NettyHandlerAdapter(handlerExecutor, this.handlers, this.responseCompleteListeners);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this.nioThreads);
        ArrayList<Channel> channels = new ArrayList<Channel>();
        GlobalTrafficShapingHandler trafficShapingHandler = new GlobalTrafficShapingHandler((ScheduledExecutorService)workerGroup, 0L, 0L, 1000L);
        MuStatsImpl stats = new MuStatsImpl(trafficShapingHandler.trafficCounter());
        ExecutorService finalHandlerExecutor = handlerExecutor;
        Function<Duration, Boolean> shutdown = gracefulDuration -> {
            try {
                if (this.wheelTimer != null) {
                    this.wheelTimer.stop();
                }
                for (Channel channel : channels) {
                    channel.close().sync();
                }
                bossGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).sync();
                boolean hasInFlightRequests = this.gracefulWait((Duration)gracefulDuration, stats);
                if (hasInFlightRequests) {
                    log.info("Shutting down worker threads. Active requests: {}", stats.activeRequests());
                }
                workerGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).sync();
                finalHandlerExecutor.shutdown();
                return hasInFlightRequests;
            }
            catch (Exception e) {
                log.info("Error while shutting down. Will ignore. Error was: {}", (Object)e.getMessage());
                return false;
            }
        };
        try {
            Channel httpsChannel;
            Channel httpChannel;
            SslContextProvider sslContextProvider = null;
            boolean http2Enabled = this.http2Config != null && this.http2Config.enabled;
            MuServerImpl server = new MuServerImpl(stats, http2Enabled, settings, this.unhandledExceptionHandler);
            Channel channel = httpChannel = this.httpPort < 0 ? null : MuServerBuilder.createChannel(bossGroup, workerGroup, nettyHandlerAdapter, this.host, this.httpPort, null, trafficShapingHandler, server, false, this.idleTimeoutMills, this.writeBufferWaterMark, this.haProxyProtocolEnabled);
            if (this.httpsPort < 0) {
                httpsChannel = null;
            } else {
                HttpsConfigBuilder toUse = this.sslContextBuilder != null ? this.sslContextBuilder : HttpsConfigBuilder.unsignedLocalhost();
                SslContext nettySslContext = toUse.toNettySslContext(http2Enabled);
                log.debug("SSL Context is " + nettySslContext);
                sslContextProvider = new SslContextProvider(nettySslContext);
                httpsChannel = MuServerBuilder.createChannel(bossGroup, workerGroup, nettyHandlerAdapter, this.host, this.httpsPort, sslContextProvider, trafficShapingHandler, server, http2Enabled, this.idleTimeoutMills, this.writeBufferWaterMark, this.haProxyProtocolEnabled);
            }
            URI uri = null;
            if (httpChannel != null) {
                channels.add(httpChannel);
                uri = MuServerBuilder.getUriFromChannel(httpChannel, "http", this.host);
            }
            URI httpsUri = null;
            if (httpsChannel != null) {
                channels.add(httpsChannel);
                httpsUri = MuServerBuilder.getUriFromChannel(httpsChannel, "https", this.host);
                ((SSLInfoImpl)sslContextProvider.sslInfo()).setHttpsUri(httpsUri);
            }
            InetSocketAddress serverAddress = (InetSocketAddress)((Channel)channels.get(0)).localAddress();
            server.onStarted(uri, httpsUri, shutdown, serverAddress, sslContextProvider);
            if (this.addShutdownHook) {
                Runtime.getRuntime().addShutdownHook(new Thread(server::stop));
            }
            return server;
        }
        catch (Exception ex) {
            shutdown.apply(Duration.ofMillis(0L));
            throw new MuException("Error while starting server", ex);
        }
    }

    private boolean gracefulWait(Duration gracefulDuration, MuStatsImpl stats) throws InterruptedException {
        long endTime = System.currentTimeMillis() + gracefulDuration.toMillis();
        while (!stats.activeRequests().isEmpty() && System.currentTimeMillis() < endTime) {
            Thread.sleep(100L);
        }
        return !stats.activeRequests().isEmpty();
    }

    private static URI getUriFromChannel(Channel httpChannel, String protocol, String host) {
        host = host == null ? "localhost" : host;
        InetSocketAddress a = (InetSocketAddress)httpChannel.localAddress();
        return URI.create(protocol + "://" + host.toLowerCase() + ":" + a.getPort());
    }

    private static Channel createChannel(NioEventLoopGroup bossGroup, NioEventLoopGroup workerGroup, final NettyHandlerAdapter nettyHandlerAdapter, String host, int port, final SslContextProvider sslContextProvider, final GlobalTrafficShapingHandler trafficShapingHandler, final MuServerImpl server, final boolean http2, final long idleTimeoutMills, WriteBufferWaterMark writeBufferWaterMark, final boolean haProxyProtocolEnabled) throws InterruptedException {
        final boolean usesSsl = sslContextProvider != null;
        final String proto = usesSsl ? "https" : "http";
        ServerBootstrap b = new ServerBootstrap();
        b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)writeBufferWaterMark);
        ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) {
                boolean addAlpn;
                ChannelPipeline p = socketChannel.pipeline();
                p.addLast("idle", (ChannelHandler)new IdleStateHandler(0L, 0L, idleTimeoutMills, TimeUnit.MILLISECONDS));
                p.addLast(new ChannelHandler[]{trafficShapingHandler});
                if (haProxyProtocolEnabled) {
                    HAProxyMessageDecoder haProxyMessageDecoder = new HAProxyMessageDecoder();
                    p.addLast("HAProxyMessageDecoder", (ChannelHandler)haProxyMessageDecoder);
                }
                if (usesSsl) {
                    SslHandler sslHandler = sslContextProvider.get().newHandler(socketChannel.alloc());
                    SSLParameters params = sslHandler.engine().getSSLParameters();
                    params.setUseCipherSuitesOrder(true);
                    sslHandler.engine().setSSLParameters(params);
                    p.addLast("ssl", (ChannelHandler)sslHandler);
                }
                boolean bl = addAlpn = http2 && usesSsl;
                if (addAlpn) {
                    p.addLast("pressure", (ChannelHandler)new BackPressureHandler());
                    p.addLast("alpn", (ChannelHandler)new AlpnHandler(nettyHandlerAdapter, server, proto));
                }
                p.addLast("conerror", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        server.stats.onFailedToConnect();
                    }
                });
                if (!addAlpn) {
                    MuServerBuilder.setupHttp1Pipeline(p, nettyHandlerAdapter, server, proto);
                }
            }
        });
        ChannelFuture bound = host == null ? b.bind(port) : b.bind(host, port);
        return bound.sync().channel();
    }

    static void setupHttp1Pipeline(ChannelPipeline p, NettyHandlerAdapter nettyHandlerAdapter, MuServerImpl server, String proto) {
        p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(server.settings().maxUrlSize + 17, server.settings().maxHeadersSize, 8192));
        p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder(){

            protected boolean isContentAlwaysEmpty(HttpResponse msg) {
                return super.isContentAlwaysEmpty(msg) || msg instanceof NettyResponseAdaptor.EmptyHttpResponse;
            }
        });
        if (server.settings().gzipEnabled) {
            p.addLast("compressor", (ChannelHandler)new SelectiveHttpContentCompressor(server.settings()));
        }
        p.addLast("keepalive", (ChannelHandler)new HttpServerKeepAliveHandler());
        p.addLast("flowControl", (ChannelHandler)new FlowControlHandler());
        p.addLast("pressure", (ChannelHandler)new BackPressureHandler());
        p.addLast("preread", (ChannelHandler)new PreReader());
        p.addLast("muhandler", (ChannelHandler)new Http1Connection(nettyHandlerAdapter, server, proto));
    }

    public String toString() {
        return "MuServerBuilder{minimumGzipSize=" + this.minimumGzipSize + ", httpPort=" + this.httpPort + ", httpsPort=" + this.httpsPort + ", maxHeadersSize=" + this.maxHeadersSize + ", maxUrlSize=" + this.maxUrlSize + ", nioThreads=" + this.nioThreads + ", handlers=" + this.handlers + ", gzipEnabled=" + this.gzipEnabled + ", mimeTypesToGzip=" + this.mimeTypesToGzip + ", addShutdownHook=" + this.addShutdownHook + ", host='" + this.host + '\'' + ", sslContextBuilder=" + this.sslContextBuilder + ", http2Config=" + this.http2Config + ", requestReadTimeoutMillis=" + this.requestReadTimeoutMillis + ", idleTimeoutMills=" + this.idleTimeoutMills + ", executor=" + this.executor + ", maxRequestSize=" + this.maxRequestSize + ", responseCompleteListeners=" + this.responseCompleteListeners + ", rateLimiters=" + this.rateLimiters + '}';
    }

    static {
        MuRuntimeDelegate.ensureSet();
        log = LoggerFactory.getLogger(MuServerBuilder.class);
        DEFAULT_NIO_THREADS = Math.min(16, Runtime.getRuntime().availableProcessors() * 2);
    }
}

