/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.MuRequest;
import io.muserver.MuStats;
import io.netty.handler.traffic.TrafficCounter;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MuStatsImpl
implements MuStats {
    private final TrafficCounter trafficCounter;
    private final AtomicLong activeConnections = new AtomicLong(0L);
    private final AtomicLong totalConnections = new AtomicLong(0L);
    private final AtomicLong completedRequests = new AtomicLong(0L);
    private final AtomicLong invalidHttpRequests = new AtomicLong(0L);
    private final AtomicLong rejectedDueToOverload = new AtomicLong(0L);
    private final AtomicLong failedToConnect = new AtomicLong(0L);
    private final Set<MuRequest> activeRequests = ConcurrentHashMap.newKeySet();
    private static final Logger log = LoggerFactory.getLogger(MuStatsImpl.class);

    MuStatsImpl(TrafficCounter trafficCounter) {
        this.trafficCounter = trafficCounter;
    }

    @Override
    public long completedConnections() {
        return this.totalConnections.get();
    }

    @Override
    public long activeConnections() {
        return this.activeConnections.get();
    }

    @Override
    public long completedRequests() {
        return this.completedRequests.get();
    }

    @Override
    public long invalidHttpRequests() {
        return this.invalidHttpRequests.get();
    }

    @Override
    public long bytesSent() {
        return this.trafficCounter.cumulativeWrittenBytes();
    }

    @Override
    public long bytesRead() {
        return this.trafficCounter.cumulativeReadBytes();
    }

    @Override
    public long rejectedDueToOverload() {
        return this.rejectedDueToOverload.get();
    }

    @Override
    public long failedToConnect() {
        return this.failedToConnect.get();
    }

    @Override
    public Set<MuRequest> activeRequests() {
        return Collections.unmodifiableSet(this.activeRequests);
    }

    void onRequestStarted(MuRequest request) {
        this.activeRequests.add(request);
    }

    void onRequestEnded(MuRequest request) {
        if (this.activeRequests.remove(request)) {
            this.completedRequests.incrementAndGet();
        } else {
            log.info("Asked to remove " + request + " but it wasn't active");
        }
    }

    void onRejectedDueToOverload() {
        this.rejectedDueToOverload.incrementAndGet();
    }

    void onInvalidRequest() {
        this.invalidHttpRequests.incrementAndGet();
    }

    void onFailedToConnect() {
        this.failedToConnect.incrementAndGet();
    }

    void onConnectionOpened() {
        this.activeConnections.incrementAndGet();
    }

    void onConnectionClosed() {
        this.activeConnections.decrementAndGet();
        this.totalConnections.incrementAndGet();
    }

    public String toString() {
        return "Active requests: " + this.activeRequests().size() + "; completed requests: " + this.completedRequests() + "; active connections: " + this.activeConnections() + "; completed connections: " + this.completedConnections() + "; invalid requests: " + this.invalidHttpRequests() + "; bytes received: " + this.bytesRead() + "; bytes sent: " + this.bytesSent() + "; rejected: " + this.rejectedDueToOverload() + "; connectionFailured: " + this.failedToConnect();
    }
}

