/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.AsyncHandle;
import io.muserver.Cookie;
import io.muserver.DoneCallback;
import io.muserver.ExchangeUpgradeEvent;
import io.muserver.FormRequestBodyReader;
import io.muserver.ForwardedHeader;
import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.HttpConnection;
import io.muserver.HttpExchange;
import io.muserver.Method;
import io.muserver.MuException;
import io.muserver.MuExceptionFiredEvent;
import io.muserver.MuRequest;
import io.muserver.MuServer;
import io.muserver.MuWebSocket;
import io.muserver.MuWebSocketSessionImpl;
import io.muserver.Mutils;
import io.muserver.NettyHandlerAdapter;
import io.muserver.NettyRequestParameters;
import io.muserver.NettyResponseAdaptor;
import io.muserver.RequestBodyListener;
import io.muserver.RequestBodyReader;
import io.muserver.RequestBodyReaderInputStreamAdapter;
import io.muserver.RequestParameters;
import io.muserver.RequestState;
import io.muserver.RequestStateChangeListener;
import io.muserver.ResponseCompleteListener;
import io.muserver.ResponseState;
import io.muserver.UploadedFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyRequestAdapter
implements MuRequest {
    private static final Logger log = LoggerFactory.getLogger(NettyRequestAdapter.class);
    private volatile RequestState state = RequestState.HEADERS_RECEIVED;
    final ChannelHandlerContext ctx;
    private final HttpRequest nettyRequest;
    private final URI serverUri;
    private final URI uri;
    private final Method method;
    private final Headers headers;
    private volatile RequestBodyReader requestBodyReader;
    private final RequestParameters query;
    private List<Cookie> cookies;
    private String contextPath = "";
    private String relativePath;
    private Map<String, Object> attributes;
    private volatile AsyncHandleImpl asyncHandle;
    private HttpExchange httpExchange;
    private final List<RequestStateChangeListener> listeners = new CopyOnWriteArrayList<RequestStateChangeListener>();

    NettyRequestAdapter(ChannelHandlerContext ctx, HttpRequest nettyRequest, Headers headers, Method method, String proto, String uri, String host) {
        this.ctx = ctx;
        this.nettyRequest = nettyRequest;
        this.serverUri = URI.create(proto + "://" + host + uri).normalize();
        this.headers = headers;
        this.uri = NettyRequestAdapter.getUri(headers, proto, host, uri, this.serverUri);
        this.relativePath = this.uri.getRawPath();
        this.query = new NettyRequestParameters(new QueryStringDecoder(uri, true).parameters());
        this.method = method;
    }

    @Override
    public boolean isAsync() {
        return this.asyncHandle != null;
    }

    @Override
    public String protocol() {
        return this.nettyRequest.protocolVersion().text();
    }

    @Override
    public HttpConnection connection() {
        return this.httpExchange.connection();
    }

    private static URI getUri(Headers h, String scheme, String hostHeader, String requestUri, URI serverUri) {
        try {
            List<ForwardedHeader> forwarded = h.forwarded();
            if (forwarded.isEmpty()) {
                return serverUri;
            }
            ForwardedHeader f = forwarded.get(0);
            String originalScheme = Mutils.coalesce(f.proto(), scheme);
            String host = Mutils.coalesce(f.host(), hostHeader);
            return new URI(originalScheme + "://" + host + requestUri).normalize();
        }
        catch (Exception e) {
            log.warn("Could not create a URI object using header values " + h + " so using local server URI. URL generation (including in redirects) may be incorrect.");
            return serverUri;
        }
    }

    @Override
    public String contentType() {
        String c = this.headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (c == null) {
            return null;
        }
        if (c.contains(";")) {
            return c.split(";")[0];
        }
        return c;
    }

    @Override
    public long startTime() {
        return this.httpExchange.startTime();
    }

    @Override
    public Method method() {
        return this.method;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public URI serverURI() {
        return this.serverUri;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    public long maxRequestBytes() {
        return this.server().maxRequestSize();
    }

    @Override
    public Optional<InputStream> inputStream() {
        if (!this.headers().hasBody()) {
            return Optional.empty();
        }
        RequestBodyReader rbr = this.requestBodyReader;
        if (rbr == null) {
            RequestBodyReaderInputStreamAdapter inputStreamReader = new RequestBodyReaderInputStreamAdapter(this.maxRequestBytes());
            try {
                this.claimingBodyRead(inputStreamReader).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MuException("Interrupted while waiting to get request body input stream");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new MuException("Error while getting input stream", cause);
            }
            return Optional.of(inputStreamReader.inputStream());
        }
        if (rbr instanceof RequestBodyReaderInputStreamAdapter) {
            return Optional.of(((RequestBodyReaderInputStreamAdapter)rbr).inputStream());
        }
        throw new IllegalStateException("Cannot read the body as an input stream when the body is already being read with a " + rbr.getClass());
    }

    @Override
    public String readBodyAsString() throws IOException {
        if (this.headers.hasBody()) {
            RequestBodyReader.StringRequestBodyReader reader = NettyRequestAdapter.createStringRequestBodyReader(this.maxRequestBytes(), this.headers());
            this.claimingBodyRead(reader);
            reader.blockUntilFullyRead();
            return reader.body();
        }
        return "";
    }

    static RequestBodyReader.StringRequestBodyReader createStringRequestBodyReader(long maxSize, Headers headers) {
        Charset bodyCharset = NettyRequestAdapter.bodyCharset(headers, true);
        return new RequestBodyReader.StringRequestBodyReader(maxSize, bodyCharset);
    }

    static Charset bodyCharset(Headers headers, boolean isRequest) {
        String charset;
        MediaType mediaType = headers.contentType();
        Charset bodyCharset = StandardCharsets.UTF_8;
        if (mediaType != null && !Mutils.nullOrEmpty(charset = (String)mediaType.getParameters().get("charset"))) {
            try {
                bodyCharset = Charset.forName(charset);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                if (isRequest) {
                    throw new ClientErrorException("Invalid request body charset", 400);
                }
                log.error("Invalid response body charset: " + mediaType, (Throwable)e);
                throw new ServerErrorException("Invalid response body charset", 500);
            }
        }
        return bodyCharset;
    }

    private Future<?> claimingBodyRead(RequestBodyReader reader) {
        if (this.requestBodyReader != null) {
            throw new IllegalStateException("The body of the request message cannot be read twice. This can happen when calling any 2 of inputStream(), readBodyAsString(), or form() methods.");
        }
        if (!this.ctx.executor().inEventLoop()) {
            return this.ctx.executor().submit(() -> this.claimingBodyRead(reader));
        }
        if (!this.state.endState()) {
            this.requestBodyReader = reader;
            this.setState(RequestState.RECEIVING_BODY);
            this.httpExchange.scheduleReadTimeout();
            return this.ctx.newSucceededFuture();
        }
        log.warn("Request body reader set after state is " + (Object)((Object)this.state));
        return this.ctx.newFailedFuture((Throwable)new IllegalStateException("Cannot claim body when state is " + (Object)((Object)this.state)));
    }

    void discardInputStreamIfNotConsumed() {
        if (this.requestBodyReader == null) {
            this.claimingBodyRead(new RequestBodyReader.DiscardingReader(this.maxRequestBytes()));
        }
    }

    @Override
    public List<UploadedFile> uploadedFiles(String name) throws IOException {
        this.ensureFormDataLoaded();
        return ((RequestBodyReader.MultipartFormReader)this.requestBodyReader).uploads(name);
    }

    @Override
    public UploadedFile uploadedFile(String name) throws IOException {
        List<UploadedFile> uploadedFiles = this.uploadedFiles(name);
        return uploadedFiles.isEmpty() ? null : uploadedFiles.get(0);
    }

    @Override
    public RequestParameters query() {
        return this.query;
    }

    @Override
    public RequestParameters form() throws IOException {
        this.ensureFormDataLoaded();
        return ((FormRequestBodyReader)((Object)this.requestBodyReader)).params();
    }

    @Override
    public List<Cookie> cookies() {
        if (this.cookies == null) {
            List<String> encoded = this.headers().getAll(HeaderNames.COOKIE);
            if (encoded.isEmpty()) {
                this.cookies = Collections.emptyList();
            } else {
                ArrayList<Cookie> theList = new ArrayList<Cookie>();
                for (String val : encoded) {
                    theList.addAll(Cookie.nettyToMu(ServerCookieDecoder.STRICT.decode(val)));
                }
                this.cookies = Collections.unmodifiableList(theList);
            }
        }
        return this.cookies;
    }

    @Override
    public Optional<String> cookie(String name) {
        List<Cookie> cookies = this.cookies();
        for (Cookie cookie : cookies) {
            if (!cookie.name().equals(name)) continue;
            return Optional.of(cookie.value());
        }
        return Optional.empty();
    }

    @Override
    public String contextPath() {
        return this.contextPath;
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    public Object attribute(String key) {
        Mutils.notNull("key", key);
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public void attribute(String key, Object value) {
        Mutils.notNull("key", key);
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    @Override
    public Map<String, Object> attributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    @Override
    public AsyncHandle handleAsync() {
        if (this.isAsync()) {
            return this.asyncHandle;
        }
        this.asyncHandle = new AsyncHandleImpl(this, this.httpExchange);
        return this.asyncHandle;
    }

    @Override
    public String remoteAddress() {
        return this.connection().remoteAddress().getHostString();
    }

    @Override
    public String clientIP() {
        List<ForwardedHeader> forwarded = this.headers.forwarded();
        for (ForwardedHeader forwardedHeader : forwarded) {
            if (forwardedHeader.forValue() == null) continue;
            return forwardedHeader.forValue();
        }
        return this.connection().remoteAddress().getHostString();
    }

    @Override
    public MuServer server() {
        return this.connection().server();
    }

    private void ensureFormDataLoaded() throws IOException {
        if (this.requestBodyReader == null) {
            RequestBodyReader reader;
            String ct = this.contentType();
            if (ct.startsWith("multipart/")) {
                reader = new RequestBodyReader.MultipartFormReader(this.maxRequestBytes(), this.nettyRequest, NettyRequestAdapter.bodyCharset(this.headers, true));
                this.claimingBodyRead(reader);
            } else if (ct.equals("application/x-www-form-urlencoded")) {
                reader = new RequestBodyReader.UrlEncodedBodyReader(NettyRequestAdapter.createStringRequestBodyReader(this.maxRequestBytes(), this.headers()));
                this.claimingBodyRead(reader);
            } else {
                throw new ServerErrorException("", 500);
            }
            reader.blockUntilFullyRead();
        } else if (!(this.requestBodyReader instanceof FormRequestBodyReader)) {
            throw new IllegalStateException("Cannot load form data when the body is being read with a " + this.requestBodyReader);
        }
    }

    public String toString() {
        return this.method().name() + " " + this.uri();
    }

    void addContext(String contextToAdd) {
        contextToAdd = NettyRequestAdapter.normaliseContext(contextToAdd);
        this.contextPath = this.contextPath + contextToAdd;
        this.relativePath = this.relativePath.substring(contextToAdd.length());
    }

    void setPaths(String contextPath, String relativePath) {
        this.contextPath = contextPath;
        this.relativePath = relativePath;
    }

    private static String normaliseContext(String contextToAdd) {
        if (contextToAdd.endsWith("/")) {
            contextToAdd = contextToAdd.substring(0, contextToAdd.length() - 1);
        }
        if (!contextToAdd.startsWith("/")) {
            contextToAdd = "/" + contextToAdd;
        }
        return contextToAdd;
    }

    void onCancelled(ResponseState reason, Throwable ex) {
        if (!this.state.endState()) {
            if (this.requestBodyReader != null && !this.requestBodyReader.completed()) {
                this.requestBodyReader.onCancelled(ex);
            }
            this.setState(RequestState.ERRORED);
        }
    }

    boolean websocketUpgrade(MuWebSocket muWebSocket, HttpHeaders responseHeaders, long idleReadTimeoutMills, long pingAfterWriteMillis, int maxFramePayloadLength) {
        DefaultFullHttpRequest fullReq;
        String url = "ws" + this.uri().toString().substring(4);
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(url, null, false, maxFramePayloadLength);
        WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)(fullReq = new DefaultFullHttpRequest(this.nettyRequest.protocolVersion(), this.nettyRequest.method(), this.nettyRequest.uri(), Unpooled.EMPTY_BUFFER, this.nettyRequest.headers(), (HttpHeaders)EmptyHttpHeaders.INSTANCE)));
        if (handshaker == null) {
            throw new UnsupportedOperationException();
        }
        this.ctx.channel().pipeline().replace("idle", "idle", (ChannelHandler)new IdleStateHandler(idleReadTimeoutMills, pingAfterWriteMillis, 0L, TimeUnit.MILLISECONDS));
        MuWebSocketSessionImpl session = new MuWebSocketSessionImpl(this.ctx, muWebSocket, this.connection());
        handshaker.handshake(this.ctx.channel(), (FullHttpRequest)fullReq, responseHeaders, this.ctx.channel().newPromise()).addListener(future -> {
            if (future.isSuccess()) {
                this.ctx.pipeline().fireUserEventTriggered((Object)new ExchangeUpgradeEvent(session));
            } else {
                this.ctx.pipeline().fireUserEventTriggered((Object)new MuExceptionFiredEvent(this.httpExchange, 0, future.cause()));
            }
        });
        return true;
    }

    public void setExchange(HttpExchange httpExchange) {
        if (httpExchange == null) {
            throw new IllegalStateException("Exchange was already set");
        }
        this.httpExchange = httpExchange;
    }

    void addChangeListener(RequestStateChangeListener listener) {
        this.listeners.add(listener);
    }

    void setState(RequestState status) {
        assert (this.httpExchange.inLoop()) : "Not in event loop";
        RequestState oldState = this.state;
        if (oldState.endState()) {
            throw new IllegalStateException("Didn't expect to get a status update to " + (Object)((Object)status) + " when the current status is " + (Object)((Object)oldState));
        }
        this.state = status;
        for (RequestStateChangeListener listener : this.listeners) {
            listener.onChange(this.httpExchange, status);
        }
    }

    void cleanup() {
        if (this.requestBodyReader != null) {
            this.requestBodyReader.cleanup();
            this.requestBodyReader = null;
        }
    }

    public RequestState requestState() {
        return this.state;
    }

    void onRequestBodyRead(ByteBuf content, boolean last, DoneCallback callback) {
        RequestBodyReader rbr = this.requestBodyReader;
        if (rbr == null) {
            throw new IllegalStateException("Got content before a request body reader was set");
        }
        rbr.onRequestBodyRead(content, last, callback);
    }

    void onReadTimeout() {
        if (this.requestBodyReader != null && !this.state.endState()) {
            this.requestBodyReader.onCancelled(new TimeoutException());
        }
    }

    public HttpExchange exchange() {
        return this.httpExchange;
    }

    static class AsyncHandleImpl
    implements AsyncHandle {
        private final NettyRequestAdapter request;
        private final HttpExchange httpExchange;

        private AsyncHandleImpl(NettyRequestAdapter request, HttpExchange httpExchange) {
            this.request = request;
            this.httpExchange = httpExchange;
        }

        @Override
        public void setReadListener(RequestBodyListener readListener) {
            if (this.request.state.endState()) {
                readListener.onComplete();
            } else {
                this.request.claimingBodyRead(new RequestBodyReader.ListenerAdapter(this, this.request.maxRequestBytes(), readListener));
            }
        }

        @Override
        public void complete() {
            if (!this.httpExchange.state().endState()) {
                if (!this.httpExchange.inLoop()) {
                    this.httpExchange.ctx.executor().execute(this::complete);
                } else {
                    this.httpExchange.complete();
                }
            }
        }

        @Override
        public void complete(Throwable throwable) {
            if (throwable == null) {
                this.complete();
            } else if (!this.httpExchange.state().endState()) {
                NettyHandlerAdapter.useCustomExceptionHandlerOrFireIt(this.httpExchange, throwable);
            }
        }

        @Override
        public void write(ByteBuffer data, DoneCallback callback) {
            ChannelFuture writeFuture = (ChannelFuture)this.write(data);
            writeFuture.addListener(future -> {
                try {
                    if (future.isSuccess()) {
                        callback.onComplete(null);
                    } else {
                        callback.onComplete(future.cause());
                    }
                }
                catch (Throwable e) {
                    log.warn("Unhandled exception from write callback", e);
                    callback.onComplete(e);
                }
            });
        }

        @Override
        public java.util.concurrent.Future<Void> write(ByteBuffer data) {
            NettyResponseAdaptor response = ((NettyRequestAdapter)this.request).httpExchange.response;
            try {
                return response.writeAndFlush(data);
            }
            catch (Throwable e) {
                return this.request.ctx.channel().newFailedFuture(e);
            }
        }

        @Override
        public void addResponseCompleteHandler(ResponseCompleteListener responseCompleteListener) {
            this.httpExchange.addChangeListener((exchange, newState) -> {
                if (newState.endState()) {
                    responseCompleteListener.onComplete(exchange);
                }
            });
        }
    }
}

