/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.Mutils;
import io.muserver.RequestParameters;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class NettyRequestParameters
implements RequestParameters {
    private final Map<String, List<String>> parameters;

    NettyRequestParameters(Map<String, List<String>> parameters) {
        Mutils.notNull("parameters", parameters);
        this.parameters = parameters;
    }

    @Override
    public Map<String, List<String>> all() {
        return this.parameters;
    }

    @Override
    public String get(String name) {
        return this.get(name, null);
    }

    @Override
    public String get(String name, String defaultValue) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Integer.parseInt(stringVal, 10);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public long getLong(String name, long defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Long.parseLong(stringVal, 10);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Float.parseFloat(stringVal);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Double.parseDouble(stringVal);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(String name) {
        String val = this.get(name, "").toLowerCase();
        return NettyRequestParameters.isTruthy(val);
    }

    static boolean isTruthy(String val) {
        switch (val) {
            case "true": 
            case "on": 
            case "yes": 
            case "1": {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> getAll(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    @Override
    public boolean contains(String name) {
        return this.parameters.containsKey(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NettyRequestParameters that = (NettyRequestParameters)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            for (String value : entry.getValue()) {
                if (!isFirst) {
                    sb.append('&');
                }
                sb.append(Mutils.urlEncode(entry.getKey())).append('=').append(Mutils.urlEncode(value));
                isFirst = false;
            }
        }
        return sb.toString();
    }
}

