/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ChunkedHttpOutputStream;
import io.muserver.ContentTypes;
import io.muserver.Cookie;
import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.HttpExchange;
import io.muserver.Method;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.NettyRequestAdapter;
import io.muserver.ResponseState;
import io.muserver.ResponseStateChangeListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.concurrent.Future;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NettyResponseAdaptor
implements MuResponse {
    private static final Logger log = LoggerFactory.getLogger(NettyResponseAdaptor.class);
    protected final boolean isHead;
    private volatile ResponseState state = ResponseState.NOTHING;
    protected final NettyRequestAdapter request;
    private final Headers headers;
    protected int status = 200;
    private volatile PrintWriter writer;
    private volatile OutputStream outputStream;
    protected long bytesStreamed = 0L;
    protected long declaredLength = -1L;
    private final List<ResponseStateChangeListener> listeners = new CopyOnWriteArrayList<ResponseStateChangeListener>();
    protected HttpExchange httpExchange;

    public void setExchange(HttpExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    protected void outputState(ResponseState state) {
        assert (this.request.ctx.executor().inEventLoop()) : "Status change to " + (Object)((Object)state) + " not in event loop";
        ResponseState oldStatus = this.state;
        if (oldStatus.endState()) {
            throw new IllegalStateException("Didn't expect to get a status update to " + (Object)((Object)state) + " when the current status is " + (Object)((Object)oldStatus));
        }
        this.state = state;
        for (ResponseStateChangeListener listener : this.listeners) {
            listener.onStateChange(this.httpExchange, state);
        }
    }

    protected void outputState(Future<? super Void> future, ResponseState successState) {
        if (future == null) {
            this.outputState(successState);
            return;
        }
        future.addListener(result -> {
            if (result.isSuccess()) {
                this.outputState(successState);
            } else if (!this.state.endState()) {
                this.outputState(ResponseState.ERRORED);
            }
        });
    }

    protected ResponseState outputState() {
        return this.state;
    }

    void addChangeListener(ResponseStateChangeListener responseStateChangeListener) {
        this.listeners.add(responseStateChangeListener);
    }

    void setWebsocket() {
        this.outputState(ResponseState.UPGRADED);
    }

    void onCancelled(ResponseState reason) {
        if (!this.state.endState()) {
            this.outputState(reason);
        }
    }

    NettyResponseAdaptor(NettyRequestAdapter request, Headers headers) {
        this.headers = headers;
        this.request = request;
        this.isHead = request.method() == Method.HEAD;
        this.headers.set(HeaderNames.DATE, (Object)Mutils.toHttpDate(new Date()));
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public void status(int value) {
        if (this.state != ResponseState.NOTHING && !this.state.completedWithError()) {
            throw new IllegalStateException("Cannot set the status after the headers have already been sent");
        }
        this.status = value;
    }

    protected ChannelFuture startStreaming() {
        assert (this.httpExchange.inLoop()) : "Not in event loop";
        if (this.state != ResponseState.NOTHING) {
            throw new IllegalStateException("Cannot start streaming when state is " + (Object)((Object)this.state));
        }
        this.declaredLength = this.headers.contains(HeaderNames.CONTENT_LENGTH) ? Long.parseLong(this.headers.get(HeaderNames.CONTENT_LENGTH)) : -1L;
        this.outputState(ResponseState.STREAMING);
        return null;
    }

    static CharSequence getVaryWithAE(String curValue) {
        if (Mutils.nullOrEmpty(curValue)) {
            return HeaderNames.ACCEPT_ENCODING;
        }
        if (!curValue.toLowerCase().contains(HeaderNames.ACCEPT_ENCODING)) {
            return curValue + ", " + HeaderNames.ACCEPT_ENCODING;
        }
        return curValue;
    }

    private void throwIfFinished() {
        if (this.state.endState()) {
            throw new IllegalStateException("Cannot write data as response has already completed");
        }
    }

    ChannelFuture writeAndFlush(ByteBuffer data) {
        if (!this.httpExchange.inLoop()) {
            ChannelPromise promise = this.httpExchange.ctx.newPromise();
            this.httpExchange.ctx.executor().submit(() -> this.writeAndFlush(data).addListener(f -> {
                if (f.isSuccess()) {
                    promise.setSuccess();
                } else {
                    promise.setFailure(f.cause());
                }
            }));
            return promise;
        }
        try {
            if (this.state.endState()) {
                throw new IllegalStateException("Cannot write when response state is " + (Object)((Object)this.state));
            }
            if (this.state == ResponseState.NOTHING) {
                this.startStreaming();
            }
            return this.writeAndFlush(Unpooled.wrappedBuffer((ByteBuffer)data));
        }
        catch (Throwable e) {
            return this.httpExchange.ctx.newFailedFuture(e);
        }
    }

    protected final ChannelFuture writeAndFlush(ByteBuf data) {
        boolean isLast;
        this.throwIfFinished();
        int size = data.writerIndex();
        this.bytesStreamed += (long)size;
        boolean bl = isLast = this.bytesStreamed == this.declaredLength;
        if (this.declaredLength > -1L && this.bytesStreamed > this.declaredLength) {
            this.onContentLengthMismatch();
            isLast = true;
        }
        ByteBuf content = Unpooled.wrappedBuffer((ByteBuf)data);
        ChannelFuture future = this.writeAndFlushToChannel(isLast, content);
        if (isLast) {
            future.addListener(wf -> {
                if (wf.isSuccess()) {
                    this.outputState(ResponseState.FULL_SENT);
                } else if (!this.state.endState()) {
                    this.outputState(ResponseState.ERRORED);
                }
            });
        }
        return future;
    }

    protected abstract void onContentLengthMismatch();

    abstract ChannelFuture writeAndFlushToChannel(boolean var1, ByteBuf var2);

    @Override
    public void sendChunk(String text) {
        this.throwIfAsync();
        this.httpExchange.block(() -> {
            this.throwIfFinished();
            if (this.state == ResponseState.NOTHING) {
                this.startStreaming();
            }
            return this.writeAndFlush(this.textToBuffer(text));
        });
    }

    private ByteBuf textToBuffer(String text) {
        if (text == null) {
            text = "";
        }
        Charset charset = NettyRequestAdapter.bodyCharset(this.headers, false);
        return Unpooled.copiedBuffer((CharSequence)text, (Charset)charset);
    }

    @Override
    public void redirect(String newLocation) {
        this.redirect(URI.create(newLocation));
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    @Override
    public void contentType(CharSequence contentType) {
        this.headers.set(HeaderNames.CONTENT_TYPE, (Object)contentType);
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.headers.add(HeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.LAX.encode((io.netty.handler.codec.http.cookie.Cookie)cookie.nettyCookie));
    }

    @Override
    public OutputStream outputStream() {
        return this.outputStream(4096);
    }

    @Override
    public OutputStream outputStream(int bufferSize) {
        if (this.outputStream == null) {
            ChunkedHttpOutputStream nonBuffered = new ChunkedHttpOutputStream(this);
            this.httpExchange.block(() -> {
                this.startStreaming();
                this.outputStream = bufferSize > 0 ? new BufferedOutputStream(nonBuffered, bufferSize) : nonBuffered;
            });
        }
        return this.outputStream;
    }

    private void throwIfAsync() {
        if (this.request.isAsync()) {
            throw new IllegalStateException("Cannot use blocking methods when in async mode");
        }
    }

    @Override
    public PrintWriter writer() {
        this.throwIfAsync();
        if (this.writer == null) {
            if (!this.headers.contains(HeaderNames.CONTENT_TYPE)) {
                this.headers.set(HeaderNames.CONTENT_TYPE, (Object)ContentTypes.TEXT_PLAIN_UTF8);
            }
            OutputStreamWriter os = new OutputStreamWriter(this.outputStream(), StandardCharsets.UTF_8);
            this.writer = new PrintWriter(os);
        }
        return this.writer;
    }

    @Override
    public boolean hasStartedSendingData() {
        return this.state != ResponseState.NOTHING;
    }

    @Override
    public ResponseState responseState() {
        return this.state;
    }

    void flushAndCloseOutputStream() {
        Mutils.closeSilently(this.writer);
        Mutils.closeSilently(this.outputStream);
    }

    void complete() {
        assert (this.httpExchange.inLoop()) : "Not in event loop";
        ResponseState finalState = ResponseState.FINISHED;
        ResponseState state = this.state;
        if (state.endState()) {
            return;
        }
        this.outputState(ResponseState.FINISHING);
        boolean isFixedLength = this.headers.contains(HeaderNames.CONTENT_LENGTH);
        ChannelFuture finishedFuture = null;
        if (state == ResponseState.NOTHING) {
            boolean addContentLengthHeader = !this.isHead && !isFixedLength && this.status != 204 && this.status != 205 && this.status != 304;
            finishedFuture = this.sendEmptyResponse(addContentLengthHeader);
        } else if (state == ResponseState.STREAMING) {
            boolean badFixedLength;
            boolean bl = badFixedLength = !this.isHead && isFixedLength && this.declaredLength != this.bytesStreamed && this.status != 304;
            if (badFixedLength) {
                log.warn("Invalid response for " + this.request + " because " + this.declaredLength + " bytes was the expected length, however " + this.bytesStreamed + " bytes were sent.");
                finalState = ResponseState.ERRORED;
            }
            if (finalState == ResponseState.FINISHED) {
                finishedFuture = this.writeLastContentMarker();
            }
        }
        this.outputState((Future<? super Void>)finishedFuture, finalState);
    }

    @Override
    public void write(String text) {
        this.throwIfAsync();
        this.httpExchange.block(() -> this.writeOnLoop(text).addListener(f -> this.outputState((Future<? super Void>)f, ResponseState.FULL_SENT)));
    }

    ChannelFuture writeOnLoop(String text) {
        this.throwIfFinished();
        if (this.state != ResponseState.NOTHING) {
            String what = this.state == ResponseState.FULL_SENT ? "twice for one response" : "after sending chunks";
            throw new IllegalStateException("You cannot call write " + what + ". If you want to send text in multiple chunks, use sendChunk instead.");
        }
        ByteBuf body = this.textToBuffer(text);
        long bodyLength = body.writerIndex();
        if (!this.headers.contains(HeaderNames.CONTENT_TYPE)) {
            this.headers.set(HeaderNames.CONTENT_TYPE, (Object)ContentTypes.TEXT_PLAIN_UTF8);
        }
        this.headers.set(HeaderNames.CONTENT_LENGTH, (Object)bodyLength);
        return this.writeFullResponse(body);
    }

    protected abstract ChannelFuture writeFullResponse(ByteBuf var1);

    protected abstract ChannelFuture writeLastContentMarker();

    @Override
    public final void redirect(URI newLocation) {
        if (!this.httpExchange.inLoop()) {
            this.httpExchange.ctx.executor().execute(() -> this.redirect(newLocation));
        } else {
            URI absoluteUrl = this.request.uri().resolve(newLocation).normalize();
            if (this.status < 300 || this.status > 303) {
                this.status(302);
            }
            this.headers.set(HeaderNames.LOCATION, (Object)absoluteUrl.toString());
        }
    }

    protected abstract ChannelFuture sendEmptyResponse(boolean var1);

    HttpResponseStatus httpStatus() {
        return HttpResponseStatus.valueOf((int)this.status());
    }

    static class EmptyHttpResponse
    extends DefaultFullHttpResponse {
        EmptyHttpResponse(HttpResponseStatus status) {
            super(HttpVersion.HTTP_1_1, status, Unpooled.buffer((int)0));
        }
    }
}

