/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ProxiedConnectionInfo;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import java.util.Objects;

class ProxiedConnectionInfoImpl
implements ProxiedConnectionInfo {
    private final String sourceAddress;
    private final int sourcePort;
    private final String destinationAddress;
    private final int destinationPort;

    private ProxiedConnectionInfoImpl(String sourceAddress, int sourcePort, String destinationAddress, int destinationPort) {
        this.sourceAddress = sourceAddress;
        this.sourcePort = sourcePort;
        this.destinationAddress = destinationAddress;
        this.destinationPort = destinationPort;
    }

    static ProxiedConnectionInfoImpl fromNetty(HAProxyMessage msg) {
        return new ProxiedConnectionInfoImpl(msg.sourceAddress(), msg.sourcePort(), msg.destinationAddress(), msg.destinationPort());
    }

    @Override
    public String sourceAddress() {
        return this.sourceAddress;
    }

    @Override
    public int sourcePort() {
        return this.sourcePort;
    }

    @Override
    public String destinationAddress() {
        return this.destinationAddress;
    }

    @Override
    public int destinationPort() {
        return this.destinationPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxiedConnectionInfoImpl that = (ProxiedConnectionInfoImpl)o;
        return this.sourcePort == that.sourcePort && this.destinationPort == that.destinationPort && Objects.equals(this.sourceAddress, that.sourceAddress) && Objects.equals(this.destinationAddress, that.destinationAddress);
    }

    public int hashCode() {
        return Objects.hash(this.sourceAddress, this.sourcePort, this.destinationAddress, this.destinationPort);
    }

    public String toString() {
        return "ProxiedConnectionInfo{sourceAddress='" + this.sourceAddress + '\'' + ", sourcePort=" + this.sourcePort + ", destinationAddress='" + this.destinationAddress + '\'' + ", destinationPort=" + this.destinationPort + '}';
    }
}

