/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.AsyncHandle;
import io.muserver.Mutils;
import io.muserver.SsePublisher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

class SsePublisherImpl
implements SsePublisher {
    private final AsyncHandle asyncHandle;

    SsePublisherImpl(AsyncHandle asyncHandle) {
        this.asyncHandle = asyncHandle;
    }

    @Override
    public void send(String message) throws IOException {
        this.send(message, null, null);
    }

    @Override
    public void send(String message, String event) throws IOException {
        this.send(message, event, null);
    }

    @Override
    public void send(String message, String event, String eventID) throws IOException {
        this.sendChunk(SsePublisherImpl.dataText(message, event, eventID));
    }

    @Override
    public void sendComment(String comment) throws IOException {
        this.sendChunk(SsePublisherImpl.commentText(comment));
    }

    @Override
    public void setClientReconnectTime(long timeToWait, TimeUnit unit) throws IOException {
        this.sendChunk(SsePublisherImpl.clientReconnectText(timeToWait, unit));
    }

    @Override
    public void close() {
        this.asyncHandle.complete();
    }

    private void sendChunk(String text) throws IOException {
        try {
            ByteBuffer buf = Mutils.toByteBuffer(text);
            this.asyncHandle.write(buf).get();
        }
        catch (Throwable e) {
            this.close();
            throw new IOException("Error while publishing SSE message", e);
        }
    }

    private static void ensureNoLineBreaks(String value, String thing) {
        if (SsePublisherImpl.containsLinebreak(value)) {
            throw new IllegalArgumentException(thing + " cannot have new line characters in them");
        }
    }

    private static boolean containsLinebreak(String value) {
        return value.contains("\n") || value.contains("\r");
    }

    static String dataText(String message, String event, String eventID) {
        StringBuilder raw = new StringBuilder();
        if (eventID != null) {
            SsePublisherImpl.ensureNoLineBreaks(eventID, "SSE IDs");
            raw.append("id: ").append(eventID).append('\n');
        }
        if (event != null) {
            SsePublisherImpl.ensureNoLineBreaks(event, "SSE event names");
            raw.append("event: ").append(event).append('\n');
        }
        if (SsePublisherImpl.containsLinebreak(message)) {
            String[] lines;
            for (String line : lines = message.split("(\r\n)|[\r\n]")) {
                raw.append("data: ").append(line).append('\n');
            }
        } else {
            raw.append("data: ").append(message).append('\n');
        }
        raw.append('\n');
        return raw.toString();
    }

    static String commentText(String comment) {
        SsePublisherImpl.ensureNoLineBreaks(comment, "SSE Comments");
        return ":" + comment + "\n\n";
    }

    static String clientReconnectText(long timeToWait, TimeUnit unit) {
        return "retry: " + unit.toMillis(timeToWait) + '\n';
    }
}

