/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.MuHandlerBuilder;
import io.muserver.MuWebSocketFactory;
import io.muserver.Mutils;
import io.muserver.WebSocketHandler;
import java.util.concurrent.TimeUnit;

public class WebSocketHandlerBuilder
implements MuHandlerBuilder<WebSocketHandler> {
    private MuWebSocketFactory factory;
    private String path;
    private long idleReadTimeoutMills = TimeUnit.MINUTES.toMillis(5L);
    private long pingAfterWriteMillis = TimeUnit.SECONDS.toMillis(30L);
    private int maxFramePayloadLength = 65536;

    public WebSocketHandlerBuilder withWebSocketFactory(MuWebSocketFactory factory) {
        Mutils.notNull("factory", factory);
        this.factory = factory;
        return this;
    }

    public WebSocketHandlerBuilder withPath(String path) {
        this.path = path;
        return this;
    }

    public WebSocketHandlerBuilder withIdleReadTimeout(long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("The duration must be 0 or greater");
        }
        Mutils.notNull("unit", (Object)unit);
        this.idleReadTimeoutMills = unit.toMillis(duration);
        return this;
    }

    public WebSocketHandlerBuilder withPingSentAfterNoWritesFor(int duration, TimeUnit unit) {
        if (duration < 0) {
            throw new IllegalArgumentException("The duration must be 0 or greater");
        }
        Mutils.notNull("unit", (Object)unit);
        this.pingAfterWriteMillis = unit.toMillis(duration);
        return this;
    }

    public WebSocketHandlerBuilder withMaxFramePayloadLength(int maxFramePayloadLength) {
        if (maxFramePayloadLength < 1024) {
            throw new IllegalArgumentException("The maxFramePayloadLength must be at least 1024 bytes");
        }
        this.maxFramePayloadLength = maxFramePayloadLength;
        return this;
    }

    @Override
    public WebSocketHandler build() {
        if (this.factory == null) {
            throw new IllegalStateException("A web socket factory must be specified");
        }
        return new WebSocketHandler(this.factory, this.path, this.idleReadTimeoutMills, this.pingAfterWriteMillis, this.maxFramePayloadLength);
    }

    public static WebSocketHandlerBuilder webSocketHandler() {
        return new WebSocketHandlerBuilder();
    }

    public static WebSocketHandlerBuilder webSocketHandler(MuWebSocketFactory factory) {
        return WebSocketHandlerBuilder.webSocketHandler().withWebSocketFactory(factory);
    }
}

