/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.Method;
import io.muserver.MuHandlerBuilder;
import io.muserver.Mutils;
import io.muserver.handlers.CORSHandler;
import io.muserver.rest.CORSConfig;
import io.muserver.rest.CORSConfigBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CORSHandlerBuilder
implements MuHandlerBuilder<CORSHandler> {
    private CORSConfig corsConfig;
    private Set<Method> allowedMethods;

    public CORSHandlerBuilder withCORSConfig(CORSConfig corsConfig) {
        Mutils.notNull("corsConfig", corsConfig);
        this.corsConfig = corsConfig;
        return this;
    }

    public CORSHandlerBuilder withCORSConfig(CORSConfigBuilder corsConfig) {
        return this.withCORSConfig(corsConfig.build());
    }

    public CORSHandlerBuilder withAllowedMethods(Method ... methods) {
        this.allowedMethods = methods == null ? null : new HashSet<Method>(Arrays.asList(methods));
        return this;
    }

    public static CORSConfigBuilder config() {
        return CORSConfigBuilder.corsConfig();
    }

    public static CORSHandlerBuilder corsHandler() {
        return new CORSHandlerBuilder();
    }

    @Override
    public CORSHandler build() {
        Set<Method> methods = this.allowedMethods;
        if (methods == null || methods.isEmpty()) {
            methods = new HashSet<Method>(Arrays.asList(Method.values()));
            methods.remove((Object)Method.TRACE);
            methods.remove((Object)Method.CONNECT);
        }
        if (this.corsConfig == null) {
            throw new IllegalStateException("You must specify the CORS config");
        }
        return new CORSHandler(this.corsConfig, methods);
    }
}

