/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.Method;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import jakarta.ws.rs.BadRequestException;
import java.net.URI;
import java.util.Set;

public class CSRFProtectionHandler
implements MuHandler {
    private final Set<String> trustedOrigins;
    private final Set<String> bypassPaths;
    private final MuHandler rejectionHandler;

    CSRFProtectionHandler(Set<String> trustedOrigins, Set<String> bypassPaths, MuHandler rejectionHandler) {
        this.trustedOrigins = trustedOrigins;
        this.bypassPaths = bypassPaths;
        this.rejectionHandler = rejectionHandler;
    }

    @Override
    public boolean handle(MuRequest request, MuResponse response) throws Exception {
        Method method = request.method();
        if (method == Method.GET || method == Method.HEAD || method == Method.OPTIONS) {
            return false;
        }
        if (this.bypassPaths.contains(request.uri().getRawPath())) {
            return false;
        }
        String secFetchSite = request.headers().get("Sec-Fetch-Site");
        if ("same-origin".equals(secFetchSite) || "none".equals(secFetchSite)) {
            return false;
        }
        if (secFetchSite == null || secFetchSite.isEmpty()) {
            String hostHeader;
            String origin = request.headers().get("Origin");
            if (origin == null || origin.isEmpty()) {
                return false;
            }
            URI uri = request.uri();
            String host = uri.getHost();
            int port = uri.getPort();
            String string = hostHeader = port > 0 ? host + ":" + port : host;
            if (origin.endsWith("://" + hostHeader) || this.trustedOrigins.contains(origin)) {
                return false;
            }
        } else if (this.trustedOrigins.contains(request.headers().get("Origin"))) {
            return false;
        }
        return this.rejectionHandler.handle(request, response);
    }

    private static MuHandler defaultRejectionHandler() {
        return (request, response) -> {
            throw new BadRequestException("Cross-origin request rejected by CSRFHandler");
        };
    }

    public String toString() {
        return "CSRFHandler{trustedOrigins=" + this.trustedOrigins + ", bypassPaths=" + this.bypassPaths + ", rejectionHandler=" + this.rejectionHandler + '}';
    }
}

