/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.MuHandler;
import io.muserver.MuHandlerBuilder;
import io.muserver.handlers.CSRFProtectionHandler;
import jakarta.ws.rs.BadRequestException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CSRFProtectionHandlerBuilder
implements MuHandlerBuilder<CSRFProtectionHandler> {
    private final Set<String> trustedOrigins = new HashSet<String>();
    private final Set<String> bypassPaths = new HashSet<String>();
    private MuHandler rejectionHandler;

    public CSRFProtectionHandlerBuilder addTrustedOrigin(String origin) {
        this.trustedOrigins.add(origin);
        return this;
    }

    public CSRFProtectionHandlerBuilder addBypassPath(String path) {
        this.bypassPaths.add(path);
        return this;
    }

    public CSRFProtectionHandlerBuilder withRejectionHandler(MuHandler handler) {
        this.rejectionHandler = handler;
        return this;
    }

    @Override
    public CSRFProtectionHandler build() {
        Set<String> trustedOriginsFinal = Collections.unmodifiableSet(new HashSet<String>(this.trustedOrigins));
        Set<String> bypassPathsFinal = Collections.unmodifiableSet(new HashSet<String>(this.bypassPaths));
        MuHandler rejectionHandlerFinal = this.rejectionHandler == null ? CSRFProtectionHandlerBuilder.defaultRejectionHandler() : this.rejectionHandler;
        return new CSRFProtectionHandler(trustedOriginsFinal, bypassPathsFinal, rejectionHandlerFinal);
    }

    private static MuHandler defaultRejectionHandler() {
        return (request, response) -> {
            throw new BadRequestException("Cross-origin request rejected by CSRFHandler");
        };
    }

    public static CSRFProtectionHandlerBuilder csrfProtection() {
        return new CSRFProtectionHandlerBuilder();
    }
}

