/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.MuException;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.handlers.ClasspathResourceProvider;
import io.muserver.handlers.ResourceProvider;
import io.muserver.handlers.ResourceProviderFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

class ClasspathCache
implements ResourceProviderFactory {
    private final String basePath;
    private final Map<String, ClasspathResourceProvider> all = new HashMap<String, ClasspathResourceProvider>();
    private static final ResourceProvider nullProvider = new ResourceProvider(){

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public Long fileSize() {
            return null;
        }

        @Override
        public Date lastModified() {
            return null;
        }

        @Override
        public boolean skipIfPossible(long bytes) {
            return false;
        }

        @Override
        public void sendTo(MuRequest request, MuResponse response, boolean sendBody, long maxLen) {
        }

        @Override
        public Stream<Path> listFiles() {
            return Stream.empty();
        }
    };

    ClasspathCache(String basePath) {
        this.basePath = basePath;
    }

    void cacheItems() throws URISyntaxException, IOException {
        URL resource = ClasspathCache.class.getResource(this.basePath);
        if (resource != null) {
            Path myPath;
            URI uri = resource.toURI();
            if (uri.getScheme().equals("jar")) {
                FileSystem zipFileSystem;
                try {
                    zipFileSystem = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException e) {
                    try {
                        zipFileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    catch (FileSystemAlreadyExistsException e2) {
                        throw new MuException("Cannot create the classpath handler as the Zip File System for this jar file has already been created");
                    }
                }
                myPath = zipFileSystem.getPath(this.basePath, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            Stream<Path> walk = Files.walk(myPath, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Date lastModified;
                Long size;
                Path cur = (Path)it.next();
                String relativePath = myPath.relativize(cur).toString().replace('\\', '/');
                boolean exists = Files.exists(cur, new LinkOption[0]);
                boolean directory = exists && Files.isDirectory(cur, new LinkOption[0]);
                try {
                    size = Files.size(cur);
                }
                catch (IOException e) {
                    size = null;
                }
                try {
                    lastModified = new Date(Files.getLastModifiedTime(cur, new LinkOption[0]).toMillis());
                }
                catch (IOException e) {
                    lastModified = null;
                }
                ClasspathResourceProvider crp = new ClasspathResourceProvider(exists, directory, size, lastModified, cur, null);
                this.all.put(relativePath, crp);
            }
            walk.close();
        }
    }

    @Override
    public ResourceProvider get(String relativePath) {
        ClasspathResourceProvider cur;
        if (relativePath.startsWith("./")) {
            relativePath = relativePath.substring(1);
        }
        if ((cur = this.all.get(relativePath = Mutils.trim(relativePath, "/"))) == null) {
            return nullProvider;
        }
        return cur.newWithInputStream();
    }

    public String toString() {
        return "ClasspathCache{basePath='" + this.basePath + '\'' + '}';
    }
}

