/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.MuException;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.handlers.ResourceProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import java.util.stream.Stream;

class ClasspathResourceProvider
implements ResourceProvider {
    private final boolean exists;
    private final boolean isDir;
    private final Long fileSize;
    private final Date lastModified;
    private final Path path;
    private final InputStream inputStream;

    ClasspathResourceProvider(boolean exists, boolean isDir, Long fileSize, Date lastModified, Path path, InputStream inputStream) {
        this.exists = exists;
        this.isDir = isDir;
        this.path = path;
        this.inputStream = inputStream;
        this.fileSize = isDir ? null : fileSize;
        this.lastModified = lastModified;
    }

    ClasspathResourceProvider newWithInputStream() {
        InputStream inputStream;
        try {
            inputStream = this.isDir ? null : Files.newInputStream(this.path, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new MuException("Error while opening " + this.path + " from the classpath", e);
        }
        return new ClasspathResourceProvider(this.exists, this.isDir, this.fileSize, this.lastModified, this.path, inputStream);
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public boolean isDirectory() {
        return this.isDir;
    }

    @Override
    public Long fileSize() {
        return this.fileSize;
    }

    @Override
    public Date lastModified() {
        return this.lastModified;
    }

    @Override
    public boolean skipIfPossible(long bytes) {
        if (bytes > 0L) {
            long skipped;
            for (long totalSkipped = 0L; totalSkipped < bytes; totalSkipped += skipped) {
                try {
                    skipped = this.inputStream.skip(bytes);
                }
                catch (IOException e) {
                    return false;
                }
                if (skipped > 0L) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendTo(MuRequest request, MuResponse response, boolean sendBody, long maxLen) throws IOException {
        block11: {
            try {
                if (!sendBody) break block11;
                try (OutputStream out = response.outputStream();){
                    int read;
                    byte[] buffer = new byte[8192];
                    long soFar = 0L;
                    while (soFar < maxLen && (read = this.inputStream.read(buffer)) > -1) {
                        if ((soFar += (long)read) > maxLen) {
                            read = (int)((long)read - (soFar - maxLen));
                        }
                        if (read <= 0) continue;
                        out.write(buffer, 0, read);
                    }
                }
            }
            finally {
                this.inputStream.close();
            }
        }
    }

    @Override
    public Stream<Path> listFiles() throws IOException {
        return Files.list(this.path);
    }
}

