/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.ContentTypes;
import io.muserver.HeaderNames;
import io.muserver.Method;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import java.net.URI;

public class HttpsRedirector
implements MuHandler {
    private final int httpsPort;
    private final long expireTimeInSeconds;
    private final boolean includeSubDomainsForHSTS;
    private final boolean preload;

    HttpsRedirector(int httpsPort, long expireTimeInSeconds, boolean includeSubDomainsForHSTS, boolean preload) {
        this.httpsPort = httpsPort;
        this.expireTimeInSeconds = expireTimeInSeconds;
        this.includeSubDomainsForHSTS = includeSubDomainsForHSTS;
        this.preload = preload;
    }

    @Override
    public boolean handle(MuRequest request, MuResponse response) throws Exception {
        URI uri = request.uri();
        boolean isHttp = uri.getScheme().equals("http");
        if (!isHttp) {
            if (this.expireTimeInSeconds > 0L) {
                String val = "max-age=" + this.expireTimeInSeconds;
                if (this.includeSubDomainsForHSTS) {
                    val = val + "; includeSubDomains";
                }
                if (this.preload) {
                    val = val + "; preload";
                }
                response.headers().set(HeaderNames.STRICT_TRANSPORT_SECURITY, (Object)val);
            }
            return false;
        }
        int port = this.httpsPort == 443 ? -1 : this.httpsPort;
        URI newURI = new URI("https", uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        if (request.method() == Method.GET || request.method() == Method.HEAD) {
            response.status(301);
            response.redirect(newURI);
        } else {
            response.status(400);
            response.contentType(ContentTypes.TEXT_PLAIN_UTF8);
            response.write("HTTP is not supported for this endpoint. Please use the HTTPS endpoint at " + newURI.resolve("/"));
        }
        return true;
    }

    public String toString() {
        return "HttpsRedirector{httpsPort=" + this.httpsPort + ", expireTimeInSeconds=" + this.expireTimeInSeconds + ", includeSubDomainsForHSTS=" + this.includeSubDomainsForHSTS + ", preload=" + this.preload + '}';
    }
}

