/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.MuHandlerBuilder;
import io.muserver.handlers.BareDirectoryRequestAction;
import io.muserver.handlers.ResourceCustomizer;
import io.muserver.handlers.ResourceHandler;
import io.muserver.handlers.ResourceProviderFactory;
import io.muserver.handlers.ResourceType;
import io.muserver.rest.RestHandlerBuilder;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;

public class ResourceHandlerBuilder
implements MuHandlerBuilder<ResourceHandler> {
    private DateTimeFormatter directoryListingDateFormatter;
    private Map<String, ResourceType> extensionToResourceType = ResourceType.DEFAULT_EXTENSION_MAPPINGS;
    private String defaultFile = "index.html";
    private ResourceProviderFactory resourceProviderFactory;
    private boolean directoryListingEnabled = false;
    private String directoryListingCss = null;
    private ResourceCustomizer resourceCustomizer = null;
    private BareDirectoryRequestAction bareDirectoryRequestAction = BareDirectoryRequestAction.REDIRECT_WITH_TRAILING_SLASH;

    public ResourceHandlerBuilder withExtensionToResourceType(Map<String, ResourceType> extensionToResourceType) {
        this.extensionToResourceType = extensionToResourceType;
        return this;
    }

    public ResourceHandlerBuilder withDefaultFile(String defaultFile) {
        this.defaultFile = defaultFile;
        return this;
    }

    ResourceHandlerBuilder withResourceProviderFactory(ResourceProviderFactory resourceProviderFactory) {
        this.resourceProviderFactory = resourceProviderFactory;
        return this;
    }

    public ResourceHandlerBuilder withDirectoryListing(boolean enabled) {
        this.directoryListingEnabled = enabled;
        return this;
    }

    public ResourceHandlerBuilder withDirectoryListingDateFormatter(DateTimeFormatter dateTimeFormatter) {
        this.directoryListingDateFormatter = dateTimeFormatter;
        return this;
    }

    public ResourceHandlerBuilder withDirectoryListingCSS(String css) {
        this.directoryListingCss = css;
        return this;
    }

    public ResourceHandlerBuilder withResourceCustomizer(ResourceCustomizer resourceCustomizer) {
        this.resourceCustomizer = resourceCustomizer;
        return this;
    }

    public DateTimeFormatter directoryListingDateFormatter() {
        return this.directoryListingDateFormatter;
    }

    public Map<String, ResourceType> extensionToResourceType() {
        return Collections.unmodifiableMap(this.extensionToResourceType);
    }

    public String defaultFile() {
        return this.defaultFile;
    }

    public boolean directoryListingEnabled() {
        return this.directoryListingEnabled;
    }

    public String directoryListingCss() {
        return this.directoryListingCss;
    }

    public ResourceCustomizer resourceCustomizer() {
        return this.resourceCustomizer;
    }

    public BareDirectoryRequestAction bareDirectoryRequestAction() {
        return this.bareDirectoryRequestAction;
    }

    public ResourceHandlerBuilder withBareDirectoryRequestAction(BareDirectoryRequestAction action) {
        if (action == null) {
            throw new IllegalArgumentException("BareDirectoryRequestAction cannot be null");
        }
        this.bareDirectoryRequestAction = action;
        return this;
    }

    @Override
    public ResourceHandler build() {
        if (this.resourceProviderFactory == null) {
            throw new IllegalStateException("No resourceProviderFactory has been set");
        }
        String css = this.directoryListingCss;
        if (this.directoryListingEnabled && css == null) {
            InputStream cssStream = RestHandlerBuilder.class.getResourceAsStream("/io/muserver/resources/api.css");
            Scanner scanner = new Scanner(cssStream, "UTF-8").useDelimiter("\\A");
            css = scanner.next();
            scanner.close();
        }
        DateTimeFormatter formatterToUse = this.directoryListingDateFormatter;
        if (this.directoryListingEnabled && formatterToUse == null) {
            formatterToUse = DateTimeFormatter.ofPattern("yyyy/MM/dd hh:mm:ss").withLocale(Locale.US).withZone(ZoneId.systemDefault());
        }
        return new ResourceHandler(this.resourceProviderFactory, this.defaultFile, this.extensionToResourceType, this.directoryListingEnabled, css, formatterToUse, this.resourceCustomizer, this.bareDirectoryRequestAction);
    }

    public static ResourceHandlerBuilder fileHandler(String directoryPath) {
        return ResourceHandlerBuilder.fileHandler(Paths.get(directoryPath, new String[0]));
    }

    public static ResourceHandlerBuilder fileHandler(File baseDirectory) {
        return ResourceHandlerBuilder.fileHandler(baseDirectory.toPath());
    }

    public static ResourceHandlerBuilder fileHandler(Path path) {
        return new ResourceHandlerBuilder().withResourceProviderFactory(ResourceProviderFactory.fileBased(path));
    }

    public static ResourceHandlerBuilder classpathHandler(String classpathRoot) {
        return new ResourceHandlerBuilder().withResourceProviderFactory(ResourceProviderFactory.classpathBased(classpathRoot));
    }

    public static ResourceHandlerBuilder fileOrClasspath(String fileRootIfExists, String classpathRoot) {
        Path path = Paths.get(fileRootIfExists, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return ResourceHandlerBuilder.fileHandler(path);
        }
        return ResourceHandlerBuilder.classpathHandler(classpathRoot);
    }
}

