/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.MuException;
import io.muserver.handlers.AsyncFileProvider;
import io.muserver.handlers.ClasspathCache;
import io.muserver.handlers.ResourceProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

interface ResourceProviderFactory {
    public ResourceProvider get(String var1);

    public static ResourceProviderFactory fileBased(final Path baseDirectory) {
        if (!Files.isDirectory(baseDirectory, LinkOption.NOFOLLOW_LINKS)) {
            throw new MuException(baseDirectory + " is not a directory");
        }
        return new ResourceProviderFactory(){

            @Override
            public ResourceProvider get(String relativePath) {
                return new AsyncFileProvider(baseDirectory, relativePath);
            }

            public String toString() {
                return "AsyncFileProviderFactory{baseDirectory='" + baseDirectory + '\'' + '}';
            }
        };
    }

    public static ResourceProviderFactory classpathBased(String classpathBase) {
        ClasspathCache classpathCache = new ClasspathCache(classpathBase);
        try {
            classpathCache.cacheItems();
        }
        catch (Exception e) {
            throw new MuException("Error while creating classpath provider", e);
        }
        return classpathCache;
    }
}

