/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.ContentTypes;
import io.muserver.HeaderNames;
import io.muserver.HeaderValues;
import io.muserver.Headers;
import io.muserver.MuException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceType {
    public static final Map<String, ResourceType> DEFAULT_EXTENSION_MAPPINGS;
    private final CharSequence mimeType;
    private final Headers headers;
    private final List<String> extensions;
    private final boolean gzip;
    public static final ResourceType DEFAULT;
    public static final ResourceType AUDIO_AAC;
    public static final ResourceType APPLICATION_X_ABIWORD;
    public static final ResourceType VIDEO_X_MSVIDEO;
    public static final ResourceType APPLICATION_VND_AMAZON_EBOOK;
    public static final ResourceType APPLICATION_OCTET_STREAM;
    public static final ResourceType APPLICATION_X_BZIP;
    public static final ResourceType APPLICATION_X_BZIP2;
    public static final ResourceType APPLICATION_X_CSH;
    public static final ResourceType TEXT_CSS;
    public static final ResourceType TEXT_PLAIN;
    public static final ResourceType TEXT_MARKDOWN;
    public static final ResourceType TEXT_CSV;
    public static final ResourceType APPLICATION_MSWORD;
    public static final ResourceType APPLICATION_VND_MS_FONTOBJECT;
    public static final ResourceType APPLICATION_EPUB_ZIP;
    public static final ResourceType APPLICATION_GZIP;
    public static final ResourceType IMAGE_GIF;
    public static final ResourceType TEXT_HTML;
    public static final ResourceType IMAGE_X_ICON;
    public static final ResourceType TEXT_CALENDAR;
    public static final ResourceType APPLICATION_JAVA_ARCHIVE;
    public static final ResourceType IMAGE_JPEG;
    public static final ResourceType APPLICATION_JAVASCRIPT;
    public static final ResourceType APPLICATION_JSON;
    public static final ResourceType WEB_APP_MANIFEST;
    public static final ResourceType AUDIO_MIDI;
    public static final ResourceType VIDEO_MP4;
    public static final ResourceType VIDEO_MPEG;
    public static final ResourceType APPLICATION_VND_APPLE_INSTALLER_XML;
    public static final ResourceType APPLICATION_VND_OASIS_OPENDOCUMENT_PRESENTATION;
    public static final ResourceType APPLICATION_VND_OASIS_OPENDOCUMENT_SPREADSHEET;
    public static final ResourceType APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT;
    public static final ResourceType AUDIO_OGG;
    public static final ResourceType VIDEO_X_MATROSKA;
    public static final ResourceType VIDEO_OGG;
    public static final ResourceType APPLICATION_OGG;
    public static final ResourceType FONT_OTF;
    public static final ResourceType IMAGE_PNG;
    public static final ResourceType APPLICATION_PDF;
    public static final ResourceType APPLICATION_VND_MS_POWERPOINT;
    public static final ResourceType APPLICATION_X_RAR_COMPRESSED;
    public static final ResourceType APPLICATION_RTF;
    public static final ResourceType APPLICATION_X_SH;
    public static final ResourceType IMAGE_SVG_XML;
    public static final ResourceType APPLICATION_X_SHOCKWAVE_FLASH;
    public static final ResourceType APPLICATION_X_TAR;
    public static final ResourceType IMAGE_TIFF;
    public static final ResourceType APPLICATION_TYPESCRIPT;
    public static final ResourceType FONT_TTF;
    public static final ResourceType APPLICATION_VND_VISIO;
    public static final ResourceType AUDIO_X_WAV;
    public static final ResourceType AUDIO_WEBM;
    public static final ResourceType VIDEO_WEBM;
    public static final ResourceType IMAGE_AVIF;
    public static final ResourceType IMAGE_WEBP;
    public static final ResourceType FONT_WOFF;
    public static final ResourceType FONT_WOFF2;
    public static final ResourceType APPLICATION_XHTML_XML;
    public static final ResourceType APPLICATION_VND_MS_EXCEL;
    public static final ResourceType APPLICATION_XML;
    public static final ResourceType APPLICATION_VND_MOZILLA_XUL_XML;
    public static final ResourceType APPLICATION_ZIP;
    public static final ResourceType VIDEO_3GPP;
    public static final ResourceType VIDEO_3GPP2;
    public static final ResourceType APPLICATION_X_7Z_COMPRESSED;

    public CharSequence mimeType() {
        return this.mimeType;
    }

    public Headers headers() {
        return this.headers;
    }

    public List<String> extensions() {
        return this.extensions;
    }

    public boolean gzip() {
        return this.gzip;
    }

    public ResourceType(CharSequence mimeType, Headers headers, boolean gzip, List<String> extensions) {
        this.mimeType = mimeType;
        this.headers = headers;
        this.gzip = gzip;
        this.extensions = extensions;
    }

    public static Headers shortCache() {
        return Headers.http2Headers().add(HeaderNames.CACHE_CONTROL, (Object)"max-age=300");
    }

    public static Headers noCache() {
        return Headers.http2Headers().add(HeaderNames.CACHE_CONTROL, (Object)HeaderValues.NO_CACHE);
    }

    public static HashMap<String, ResourceType> getDefaultMapping() {
        HashMap<String, ResourceType> map = new HashMap<String, ResourceType>();
        for (ResourceType rt : ResourceType.getResourceTypes()) {
            for (String extension : rt.extensions()) {
                map.put(extension, rt);
            }
        }
        return map;
    }

    public static Set<String> gzippableMimeTypes(Collection<ResourceType> resourceTypes) {
        return resourceTypes.stream().filter(ResourceType::gzip).map(rt -> {
            String s = rt.mimeType().toString();
            int i = s.indexOf(";");
            if (i > -1) {
                s = s.substring(0, i);
            }
            return s;
        }).collect(Collectors.toSet());
    }

    public static List<ResourceType> getResourceTypes() {
        ArrayList<ResourceType> all = new ArrayList<ResourceType>();
        for (Field field : ResourceType.class.getDeclaredFields()) {
            Class<?> type = field.getType();
            int modifiers = field.getModifiers();
            if (!type.equals(ResourceType.class) || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            field.setAccessible(true);
            try {
                ResourceType rt = (ResourceType)field.get(null);
                all.add(rt);
            }
            catch (IllegalAccessException e) {
                throw new MuException("Error getting resource types for " + field, e);
            }
        }
        return all;
    }

    public String toString() {
        return "ResourceType{mimeType=" + this.mimeType() + ", headers=" + this.headers() + ", extensions=" + this.extensions() + ", gzip=" + this.gzip() + '}';
    }

    static {
        DEFAULT = new ResourceType(ContentTypes.APPLICATION_OCTET_STREAM, ResourceType.shortCache(), false, Collections.emptyList());
        AUDIO_AAC = new ResourceType(ContentTypes.AUDIO_AAC, ResourceType.shortCache(), false, Collections.singletonList("aac"));
        APPLICATION_X_ABIWORD = new ResourceType(ContentTypes.APPLICATION_X_ABIWORD, ResourceType.shortCache(), false, Collections.singletonList("abw"));
        VIDEO_X_MSVIDEO = new ResourceType(ContentTypes.VIDEO_X_MSVIDEO, ResourceType.shortCache(), false, Collections.singletonList("avi"));
        APPLICATION_VND_AMAZON_EBOOK = new ResourceType(ContentTypes.APPLICATION_VND_AMAZON_EBOOK, ResourceType.shortCache(), false, Collections.singletonList("azw"));
        APPLICATION_OCTET_STREAM = new ResourceType(ContentTypes.APPLICATION_OCTET_STREAM, ResourceType.shortCache(), false, Arrays.asList("bin", "arc"));
        APPLICATION_X_BZIP = new ResourceType(ContentTypes.APPLICATION_X_BZIP, ResourceType.shortCache(), false, Collections.singletonList("bz"));
        APPLICATION_X_BZIP2 = new ResourceType(ContentTypes.APPLICATION_X_BZIP2, ResourceType.shortCache(), false, Collections.singletonList("bz2"));
        APPLICATION_X_CSH = new ResourceType(ContentTypes.APPLICATION_X_CSH, ResourceType.shortCache(), false, Collections.singletonList("csh"));
        TEXT_CSS = new ResourceType(ContentTypes.TEXT_CSS, Headers.http2Headers().add(HeaderNames.CACHE_CONTROL, (Object)"max-age=300").add(HeaderNames.X_CONTENT_TYPE_OPTIONS, (Object)HeaderValues.NOSNIFF), true, Collections.singletonList("css"));
        TEXT_PLAIN = new ResourceType(ContentTypes.TEXT_PLAIN_UTF8, ResourceType.noCache(), true, Arrays.asList("txt", "ini", "gitignore", "gitattributes", "cfg", "log", "out", "text", "properties"));
        TEXT_MARKDOWN = new ResourceType(ContentTypes.TEXT_MARKDOWN_UTF8, ResourceType.shortCache(), true, Collections.singletonList("md"));
        TEXT_CSV = new ResourceType(ContentTypes.TEXT_CSV_UTF8, ResourceType.noCache(), true, Collections.singletonList("csv"));
        APPLICATION_MSWORD = new ResourceType(ContentTypes.APPLICATION_MSWORD, ResourceType.shortCache(), false, Collections.singletonList("doc"));
        APPLICATION_VND_MS_FONTOBJECT = new ResourceType(ContentTypes.APPLICATION_VND_MS_FONTOBJECT, ResourceType.shortCache(), false, Collections.singletonList("eot"));
        APPLICATION_EPUB_ZIP = new ResourceType(ContentTypes.APPLICATION_EPUB_ZIP, ResourceType.shortCache(), false, Collections.singletonList("epub"));
        APPLICATION_GZIP = new ResourceType(ContentTypes.APPLICATION_GZIP, ResourceType.shortCache(), false, Collections.singletonList("gz"));
        IMAGE_GIF = new ResourceType(ContentTypes.IMAGE_GIF, ResourceType.shortCache(), false, Collections.singletonList("gif"));
        TEXT_HTML = new ResourceType(ContentTypes.TEXT_HTML_UTF8, ResourceType.noCache(), true, Arrays.asList("html", "htm"));
        IMAGE_X_ICON = new ResourceType(ContentTypes.IMAGE_X_ICON, ResourceType.shortCache(), false, Collections.singletonList("ico"));
        TEXT_CALENDAR = new ResourceType(ContentTypes.TEXT_CALENDAR_UTF8, ResourceType.noCache(), true, Collections.singletonList("ics"));
        APPLICATION_JAVA_ARCHIVE = new ResourceType(ContentTypes.APPLICATION_JAVA_ARCHIVE, ResourceType.shortCache(), false, Collections.singletonList("jar"));
        IMAGE_JPEG = new ResourceType(ContentTypes.IMAGE_JPEG, ResourceType.shortCache(), false, Arrays.asList("jpg", "jpeg"));
        APPLICATION_JAVASCRIPT = new ResourceType(ContentTypes.APPLICATION_JAVASCRIPT, Headers.http2Headers().add(HeaderNames.CACHE_CONTROL, (Object)"max-age=86400").add(HeaderNames.X_CONTENT_TYPE_OPTIONS, (Object)HeaderValues.NOSNIFF), true, Arrays.asList("js", "mjs"));
        APPLICATION_JSON = new ResourceType(ContentTypes.APPLICATION_JSON, ResourceType.noCache(), true, Collections.singletonList("json"));
        WEB_APP_MANIFEST = new ResourceType(ContentTypes.WEB_APP_MANIFEST, Headers.http2Headers().add(HeaderNames.CACHE_CONTROL, (Object)"max-age=300"), true, Collections.singletonList("webmanifest"));
        AUDIO_MIDI = new ResourceType(ContentTypes.AUDIO_MIDI, ResourceType.shortCache(), false, Arrays.asList("mid", "midi"));
        VIDEO_MP4 = new ResourceType(ContentTypes.VIDEO_MP4, ResourceType.shortCache(), false, Collections.singletonList("mp4"));
        VIDEO_MPEG = new ResourceType(ContentTypes.VIDEO_MPEG, ResourceType.shortCache(), false, Collections.singletonList("mpeg"));
        APPLICATION_VND_APPLE_INSTALLER_XML = new ResourceType(ContentTypes.APPLICATION_VND_APPLE_INSTALLER_XML, ResourceType.shortCache(), true, Collections.singletonList("mpkg"));
        APPLICATION_VND_OASIS_OPENDOCUMENT_PRESENTATION = new ResourceType(ContentTypes.APPLICATION_VND_OASIS_OPENDOCUMENT_PRESENTATION, ResourceType.shortCache(), false, Collections.singletonList("odp"));
        APPLICATION_VND_OASIS_OPENDOCUMENT_SPREADSHEET = new ResourceType(ContentTypes.APPLICATION_VND_OASIS_OPENDOCUMENT_SPREADSHEET, ResourceType.shortCache(), false, Collections.singletonList("ods"));
        APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT = new ResourceType(ContentTypes.APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT, ResourceType.shortCache(), true, Collections.singletonList("odt"));
        AUDIO_OGG = new ResourceType(ContentTypes.AUDIO_OGG, ResourceType.shortCache(), false, Collections.singletonList("oga"));
        VIDEO_X_MATROSKA = new ResourceType(ContentTypes.VIDEO_X_MATROSKA, ResourceType.shortCache(), false, Collections.singletonList("mkv"));
        VIDEO_OGG = new ResourceType(ContentTypes.VIDEO_OGG, ResourceType.shortCache(), false, Collections.singletonList("ogv"));
        APPLICATION_OGG = new ResourceType(ContentTypes.APPLICATION_OGG, ResourceType.shortCache(), false, Collections.singletonList("ogx"));
        FONT_OTF = new ResourceType(ContentTypes.FONT_OTF, ResourceType.shortCache(), true, Collections.singletonList("otf"));
        IMAGE_PNG = new ResourceType(ContentTypes.IMAGE_PNG, ResourceType.shortCache(), false, Collections.singletonList("png"));
        APPLICATION_PDF = new ResourceType(ContentTypes.APPLICATION_PDF, ResourceType.shortCache(), false, Collections.singletonList("pdf"));
        APPLICATION_VND_MS_POWERPOINT = new ResourceType(ContentTypes.APPLICATION_VND_MS_POWERPOINT, ResourceType.shortCache(), false, Collections.singletonList("ppt"));
        APPLICATION_X_RAR_COMPRESSED = new ResourceType(ContentTypes.APPLICATION_X_RAR_COMPRESSED, ResourceType.shortCache(), false, Collections.singletonList("rar"));
        APPLICATION_RTF = new ResourceType(ContentTypes.APPLICATION_RTF, ResourceType.shortCache(), true, Collections.singletonList("rtf"));
        APPLICATION_X_SH = new ResourceType(ContentTypes.APPLICATION_X_SH, ResourceType.shortCache(), true, Collections.singletonList("sh"));
        IMAGE_SVG_XML = new ResourceType(ContentTypes.IMAGE_SVG_XML, ResourceType.shortCache(), true, Collections.singletonList("svg"));
        APPLICATION_X_SHOCKWAVE_FLASH = new ResourceType(ContentTypes.APPLICATION_X_SHOCKWAVE_FLASH, ResourceType.shortCache(), false, Collections.singletonList("swf"));
        APPLICATION_X_TAR = new ResourceType(ContentTypes.APPLICATION_X_TAR, ResourceType.shortCache(), false, Collections.singletonList("tar"));
        IMAGE_TIFF = new ResourceType(ContentTypes.IMAGE_TIFF, ResourceType.shortCache(), false, Arrays.asList("tiff", "tif"));
        APPLICATION_TYPESCRIPT = new ResourceType(ContentTypes.APPLICATION_TYPESCRIPT, ResourceType.shortCache(), true, Collections.singletonList("ts"));
        FONT_TTF = new ResourceType(ContentTypes.FONT_TTF, ResourceType.shortCache(), true, Collections.singletonList("ttf"));
        APPLICATION_VND_VISIO = new ResourceType(ContentTypes.APPLICATION_VND_VISIO, ResourceType.shortCache(), false, Collections.singletonList("vsd"));
        AUDIO_X_WAV = new ResourceType(ContentTypes.AUDIO_X_WAV, ResourceType.shortCache(), false, Collections.singletonList("wav"));
        AUDIO_WEBM = new ResourceType(ContentTypes.AUDIO_WEBM, ResourceType.shortCache(), false, Collections.singletonList("weba"));
        VIDEO_WEBM = new ResourceType(ContentTypes.VIDEO_WEBM, ResourceType.shortCache(), false, Collections.singletonList("webm"));
        IMAGE_AVIF = new ResourceType(ContentTypes.IMAGE_AVIF, ResourceType.shortCache(), false, Collections.singletonList("avif"));
        IMAGE_WEBP = new ResourceType(ContentTypes.IMAGE_WEBP, ResourceType.shortCache(), false, Collections.singletonList("webp"));
        FONT_WOFF = new ResourceType(ContentTypes.FONT_WOFF, ResourceType.shortCache(), false, Collections.singletonList("woff"));
        FONT_WOFF2 = new ResourceType(ContentTypes.FONT_WOFF2, ResourceType.shortCache(), false, Collections.singletonList("woff2"));
        APPLICATION_XHTML_XML = new ResourceType(ContentTypes.APPLICATION_XHTML_XML, ResourceType.shortCache(), true, Collections.singletonList("xhtml"));
        APPLICATION_VND_MS_EXCEL = new ResourceType(ContentTypes.APPLICATION_VND_MS_EXCEL, ResourceType.shortCache(), false, Arrays.asList("xls", "xlsx"));
        APPLICATION_XML = new ResourceType(ContentTypes.APPLICATION_XML, ResourceType.shortCache(), true, Collections.singletonList("xml"));
        APPLICATION_VND_MOZILLA_XUL_XML = new ResourceType(ContentTypes.APPLICATION_VND_MOZILLA_XUL_XML, ResourceType.shortCache(), true, Collections.singletonList("xul"));
        APPLICATION_ZIP = new ResourceType(ContentTypes.APPLICATION_ZIP, ResourceType.shortCache(), false, Collections.singletonList("zip"));
        VIDEO_3GPP = new ResourceType(ContentTypes.VIDEO_3GPP, ResourceType.shortCache(), false, Collections.singletonList("3gp"));
        VIDEO_3GPP2 = new ResourceType(ContentTypes.VIDEO_3GPP2, ResourceType.shortCache(), false, Collections.singletonList("3g2"));
        APPLICATION_X_7Z_COMPRESSED = new ResourceType(ContentTypes.APPLICATION_X_7Z_COMPRESSED, ResourceType.shortCache(), false, Collections.singletonList("7z"));
        DEFAULT_EXTENSION_MAPPINGS = Collections.unmodifiableMap(ResourceType.getDefaultMapping());
    }
}

