/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.CallbackObject;
import io.muserver.openapi.ExampleObject;
import io.muserver.openapi.HeaderObject;
import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.LinkObject;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.RequestBodyObject;
import io.muserver.openapi.ResponseObject;
import io.muserver.openapi.SchemaObject;
import io.muserver.openapi.SecuritySchemeObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;

public class ComponentsObject
implements JsonWriter {
    private final Map<String, SchemaObject> schemas;
    private final Map<String, ResponseObject> responses;
    private final Map<String, ParameterObject> parameters;
    private final Map<String, ExampleObject> examples;
    private final Map<String, RequestBodyObject> requestBodies;
    private final Map<String, HeaderObject> headers;
    private final Map<String, SecuritySchemeObject> securitySchemes;
    private final Map<String, LinkObject> links;
    private final Map<String, CallbackObject> callbacks;

    ComponentsObject(Map<String, SchemaObject> schemas, Map<String, ResponseObject> responses, Map<String, ParameterObject> parameters, Map<String, ExampleObject> examples, Map<String, RequestBodyObject> requestBodies, Map<String, HeaderObject> headers, Map<String, SecuritySchemeObject> securitySchemes, Map<String, LinkObject> links, Map<String, CallbackObject> callbacks) {
        this.checkKey(schemas, responses, parameters, examples, requestBodies, headers, securitySchemes, links, callbacks);
        this.schemas = schemas;
        this.responses = responses;
        this.parameters = parameters;
        this.examples = examples;
        this.requestBodies = requestBodies;
        this.headers = headers;
        this.securitySchemes = securitySchemes;
        this.links = links;
        this.callbacks = callbacks;
    }

    private void checkKey(Map<String, ?> ... maps) {
        Pattern keyPattern = Pattern.compile("^[a-zA-Z0-9.\\-_]+$");
        for (Map<String, ?> map : maps) {
            if (map == null) continue;
            for (String key : map.keySet()) {
                if (keyPattern.matcher(key).matches()) continue;
                throw new IllegalArgumentException("The value '" + key + "' is not a valid key. It must match " + keyPattern);
            }
        }
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.write(123);
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "schemas", this.schemas, isFirst);
        isFirst = Jsonizer.append(writer, "responses", this.responses, isFirst);
        isFirst = Jsonizer.append(writer, "parameters", this.parameters, isFirst);
        isFirst = Jsonizer.append(writer, "examples", this.examples, isFirst);
        isFirst = Jsonizer.append(writer, "requestBodies", this.requestBodies, isFirst);
        isFirst = Jsonizer.append(writer, "headers", this.headers, isFirst);
        isFirst = Jsonizer.append(writer, "securitySchemes", this.securitySchemes, isFirst);
        isFirst = Jsonizer.append(writer, "links", this.links, isFirst);
        isFirst = Jsonizer.append(writer, "callbacks", this.callbacks, isFirst);
        writer.write(125);
    }

    public Map<String, SchemaObject> schemas() {
        return this.schemas;
    }

    public Map<String, ResponseObject> responses() {
        return this.responses;
    }

    public Map<String, ParameterObject> parameters() {
        return this.parameters;
    }

    public Map<String, ExampleObject> examples() {
        return this.examples;
    }

    public Map<String, RequestBodyObject> requestBodies() {
        return this.requestBodies;
    }

    public Map<String, HeaderObject> headers() {
        return this.headers;
    }

    public Map<String, SecuritySchemeObject> securitySchemes() {
        return this.securitySchemes;
    }

    public Map<String, LinkObject> links() {
        return this.links;
    }

    public Map<String, CallbackObject> callbacks() {
        return this.callbacks;
    }
}

