/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.HeaderObject;
import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.ParameterObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class EncodingObject
implements JsonWriter {
    private final String contentType;
    private final Map<String, HeaderObject> headers;
    private final String style;
    private final Boolean explode;
    private final Boolean allowReserved;

    EncodingObject(String contentType, Map<String, HeaderObject> headers, String style, Boolean explode, Boolean allowReserved) {
        if (style != null && !ParameterObject.allowedStyles().contains(style)) {
            throw new IllegalArgumentException("'style' must be one of " + ParameterObject.allowedStyles() + " but was " + style);
        }
        this.contentType = contentType;
        this.headers = headers;
        this.style = style;
        this.explode = explode;
        this.allowReserved = allowReserved;
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.append('{');
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "contentType", this.contentType, isFirst);
        isFirst = Jsonizer.append(writer, "headers", this.headers, isFirst);
        isFirst = Jsonizer.append(writer, "style", this.style, isFirst);
        isFirst = Jsonizer.append(writer, "explode", this.explode, isFirst);
        isFirst = Jsonizer.append(writer, "allowReserved", this.allowReserved, isFirst);
        writer.append('}');
    }

    public String contentType() {
        return this.contentType;
    }

    public Map<String, HeaderObject> headers() {
        return this.headers;
    }

    public String style() {
        return this.style;
    }

    public boolean explode() {
        return ParameterObject.actualValue(this.explode, this.style == null || "form".equals(this.style));
    }

    public boolean allowReserved() {
        return ParameterObject.actualValue(this.allowReserved, false);
    }
}

