/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.ExampleObject;
import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.MediaTypeObject;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.SchemaObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class HeaderObject
implements JsonWriter {
    private final String description;
    private final Boolean required;
    private final Boolean deprecated;
    private final String style;
    private final Boolean explode;
    private final SchemaObject schema;
    private final Object example;
    private final Map<String, ExampleObject> examples;
    private final Map<String, MediaTypeObject> content;

    HeaderObject(String description, Boolean required, Boolean deprecated, String style, Boolean explode, SchemaObject schema, Object example, Map<String, ExampleObject> examples, Map<String, MediaTypeObject> content) {
        if (style != null && !ParameterObject.allowedStyles().contains(style)) {
            throw new IllegalArgumentException("'style' must be one of " + ParameterObject.allowedStyles() + " but was " + style);
        }
        if (content != null && content.size() != 1) {
            throw new IllegalArgumentException("'content', when specified, must have a single value only, but was " + content);
        }
        if (example != null && examples != null) {
            throw new IllegalArgumentException("Only one of 'example' and 'examples' can be supplied");
        }
        this.description = description;
        this.required = required;
        this.deprecated = deprecated;
        this.style = style;
        this.explode = explode;
        this.schema = schema;
        this.example = example;
        this.examples = examples;
        this.content = content;
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.write(123);
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "description", this.description, isFirst);
        isFirst = Jsonizer.append(writer, "required", this.required, isFirst);
        isFirst = Jsonizer.append(writer, "deprecated", this.deprecated, isFirst);
        isFirst = Jsonizer.append(writer, "style", this.style, isFirst);
        isFirst = Jsonizer.append(writer, "explode", this.explode, isFirst);
        isFirst = Jsonizer.append(writer, "schema", this.schema, isFirst);
        isFirst = Jsonizer.append(writer, "example", this.example, isFirst);
        isFirst = Jsonizer.append(writer, "examples", this.examples, isFirst);
        isFirst = Jsonizer.append(writer, "content", this.content, isFirst);
        writer.write(125);
    }

    public String description() {
        return this.description;
    }

    public boolean required() {
        return ParameterObject.actualValue(this.required, false);
    }

    public boolean deprecated() {
        return ParameterObject.actualValue(this.deprecated, false);
    }

    public String style() {
        return this.style;
    }

    public boolean explode() {
        return ParameterObject.actualValue(this.explode, this.style == null || "form".equals(this.style));
    }

    public SchemaObject schema() {
        return this.schema;
    }

    public Object example() {
        return this.example;
    }

    public Map<String, ExampleObject> examples() {
        return this.examples;
    }

    public Map<String, MediaTypeObject> content() {
        return this.content;
    }
}

