/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.EncodingObject;
import io.muserver.openapi.ExampleObject;
import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.SchemaObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class MediaTypeObject
implements JsonWriter {
    private final SchemaObject schema;
    private final Object example;
    private final Map<String, ExampleObject> examples;
    private final Map<String, EncodingObject> encoding;

    MediaTypeObject(SchemaObject schema, Object example, Map<String, ExampleObject> examples, Map<String, EncodingObject> encoding) {
        if (example != null && examples != null) {
            throw new IllegalArgumentException("Only one of 'example' and 'examples' can be supplied");
        }
        this.schema = schema;
        this.example = example;
        this.examples = examples;
        this.encoding = encoding;
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.append('{');
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "schema", this.schema, isFirst);
        isFirst = Jsonizer.append(writer, "example", this.example, isFirst);
        isFirst = Jsonizer.append(writer, "examples", this.examples, isFirst);
        isFirst = Jsonizer.append(writer, "encoding", this.encoding, isFirst);
        writer.append('}');
    }

    public SchemaObject schema() {
        return this.schema;
    }

    public Object example() {
        return this.example;
    }

    public Map<String, ExampleObject> examples() {
        return this.examples;
    }

    public Map<String, EncodingObject> encoding() {
        return this.encoding;
    }
}

