/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.EncodingObject;
import io.muserver.openapi.ExampleObject;
import io.muserver.openapi.MediaTypeObject;
import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.SchemaObject;
import java.util.Map;

public class MediaTypeObjectBuilder {
    private SchemaObject schema;
    private Object example;
    private Map<String, ExampleObject> examples;
    private Map<String, EncodingObject> encoding;

    public MediaTypeObjectBuilder withSchema(SchemaObject schema) {
        this.schema = schema;
        return this;
    }

    public MediaTypeObjectBuilder withExample(Object example) {
        this.example = example;
        return this;
    }

    public MediaTypeObjectBuilder withExamples(Map<String, ExampleObject> examples) {
        this.examples = examples;
        return this;
    }

    public MediaTypeObjectBuilder withEncoding(Map<String, EncodingObject> encoding) {
        this.encoding = encoding;
        return this;
    }

    public MediaTypeObject build() {
        return new MediaTypeObject(this.schema, this.example, OpenApiUtils.immutable(this.examples), OpenApiUtils.immutable(this.encoding));
    }

    public static MediaTypeObjectBuilder mediaTypeObject() {
        return new MediaTypeObjectBuilder();
    }
}

