/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.CallbackObject;
import io.muserver.openapi.ExternalDocumentationObject;
import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.OperationObject;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.RequestBodyObject;
import io.muserver.openapi.ResponsesObject;
import io.muserver.openapi.SecurityRequirementObject;
import io.muserver.openapi.ServerObject;
import java.util.List;
import java.util.Map;

public class OperationObjectBuilder {
    private List<String> tags;
    private String summary;
    private String description;
    private ExternalDocumentationObject externalDocs;
    private String operationId;
    private List<ParameterObject> parameters;
    private RequestBodyObject requestBody;
    private ResponsesObject responses;
    private Map<String, CallbackObject> callbacks;
    private Boolean deprecated;
    private List<SecurityRequirementObject> security;
    private List<ServerObject> servers;

    public OperationObjectBuilder withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public OperationObjectBuilder withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public OperationObjectBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public OperationObjectBuilder withExternalDocs(ExternalDocumentationObject externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public OperationObjectBuilder withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public OperationObjectBuilder withParameters(List<ParameterObject> parameters) {
        this.parameters = parameters;
        return this;
    }

    public OperationObjectBuilder withRequestBody(RequestBodyObject requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public OperationObjectBuilder withResponses(ResponsesObject responses) {
        this.responses = responses;
        return this;
    }

    public OperationObjectBuilder withCallbacks(Map<String, CallbackObject> callbacks) {
        this.callbacks = callbacks;
        return this;
    }

    public OperationObjectBuilder withDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public OperationObjectBuilder withSecurity(List<SecurityRequirementObject> security) {
        this.security = security;
        return this;
    }

    public OperationObjectBuilder withServers(List<ServerObject> servers) {
        this.servers = servers;
        return this;
    }

    public OperationObject build() {
        return new OperationObject(OpenApiUtils.immutable(this.tags), this.summary, this.description, this.externalDocs, this.operationId, OpenApiUtils.immutable(this.parameters), this.requestBody, this.responses, OpenApiUtils.immutable(this.callbacks), this.deprecated, OpenApiUtils.immutable(this.security), OpenApiUtils.immutable(this.servers));
    }

    public static OperationObjectBuilder operationObject() {
        return new OperationObjectBuilder();
    }

    public static OperationObjectBuilder builderFrom(OperationObject operation) {
        return new OperationObjectBuilder().withTags(operation.tags()).withSummary(operation.summary()).withDescription(operation.description()).withExternalDocs(operation.externalDocs()).withOperationId(operation.operationId()).withParameters(operation.parameters()).withRequestBody(operation.requestBody()).withResponses(operation.responses()).withCallbacks(operation.callbacks()).withDeprecated(operation.deprecated()).withSecurity(operation.security()).withServers(operation.servers());
    }
}

