/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.ExampleObject;
import io.muserver.openapi.MediaTypeObject;
import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.SchemaObject;
import java.util.Map;

public class ParameterObjectBuilder {
    private String name;
    private String in;
    private String description;
    private Boolean required;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private String style;
    private Boolean explode;
    private Boolean allowReserved;
    private SchemaObject schema;
    private Object example;
    private Map<String, ExampleObject> examples;
    private Map<String, MediaTypeObject> content;

    public ParameterObjectBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public ParameterObjectBuilder withIn(String in) {
        this.in = in;
        return this;
    }

    public ParameterObjectBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ParameterObjectBuilder withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public ParameterObjectBuilder withDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public ParameterObjectBuilder withAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
        return this;
    }

    public ParameterObjectBuilder withStyle(String style) {
        this.style = style;
        return this;
    }

    public ParameterObjectBuilder withExplode(Boolean explode) {
        this.explode = explode;
        return this;
    }

    public ParameterObjectBuilder withAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
        return this;
    }

    public ParameterObjectBuilder withSchema(SchemaObject schema) {
        this.schema = schema;
        return this;
    }

    public ParameterObjectBuilder withExample(Object example) {
        this.example = example;
        return this;
    }

    public ParameterObjectBuilder withExamples(Map<String, ExampleObject> examples) {
        this.examples = examples;
        return this;
    }

    public ParameterObjectBuilder withContent(Map<String, MediaTypeObject> content) {
        this.content = content;
        return this;
    }

    public ParameterObject build() {
        boolean requiredVal = this.required == null ? "path".equals(this.in) : this.required.booleanValue();
        return new ParameterObject(this.name, this.in, this.description, requiredVal, this.deprecated, this.allowEmptyValue, this.style, this.explode, this.allowReserved, this.schema, this.example, OpenApiUtils.immutable(this.examples), OpenApiUtils.immutable(this.content));
    }

    public static ParameterObjectBuilder parameterObject() {
        return new ParameterObjectBuilder();
    }
}

