/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.OperationObject;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.ServerObject;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PathItemObject
implements JsonWriter {
    private final String summary;
    private final String description;
    private final Map<String, OperationObject> operations;
    private final List<ServerObject> servers;
    private final List<ParameterObject> parameters;

    PathItemObject(String summary, String description, Map<String, OperationObject> operations, List<ServerObject> servers, List<ParameterObject> parameters) {
        Set nameIns;
        if (parameters != null && (nameIns = parameters.stream().map(p -> p.name() + "\u0000" + p.in()).collect(Collectors.toSet())).size() != parameters.size()) {
            throw new IllegalArgumentException("Got duplicate parameter name and locations in " + parameters);
        }
        this.summary = summary;
        this.description = description;
        this.operations = operations;
        this.servers = servers;
        this.parameters = parameters;
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.write(123);
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "summary", this.summary, isFirst);
        isFirst = Jsonizer.append(writer, "description", this.description, isFirst);
        if (this.operations != null) {
            for (String method : new String[]{"get", "put", "post", "delete", "options", "head", "patch", "trace"}) {
                isFirst = Jsonizer.append(writer, method, this.operations.get(method), isFirst);
            }
        }
        isFirst = Jsonizer.append(writer, "servers", this.servers, isFirst);
        isFirst = Jsonizer.append(writer, "parameters", this.parameters, isFirst);
        writer.write(125);
    }

    public String summary() {
        return this.summary;
    }

    public String description() {
        return this.description;
    }

    public Map<String, OperationObject> operations() {
        return this.operations;
    }

    public List<ServerObject> servers() {
        return this.servers;
    }

    public List<ParameterObject> parameters() {
        return this.parameters;
    }
}

