/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.OperationObject;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.PathItemObject;
import io.muserver.openapi.ServerObject;
import java.util.List;
import java.util.Map;

public class PathItemObjectBuilder {
    private String summary;
    private String description;
    private Map<String, OperationObject> operations;
    private List<ServerObject> servers;
    private List<ParameterObject> parameters;

    public PathItemObjectBuilder withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public PathItemObjectBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public PathItemObjectBuilder withOperations(Map<String, OperationObject> operations) {
        this.operations = operations;
        return this;
    }

    public PathItemObjectBuilder withServers(List<ServerObject> servers) {
        this.servers = servers;
        return this;
    }

    public PathItemObjectBuilder withParameters(List<ParameterObject> parameters) {
        this.parameters = parameters;
        return this;
    }

    public PathItemObject build() {
        return new PathItemObject(this.summary, this.description, OpenApiUtils.immutable(this.operations), OpenApiUtils.immutable(this.servers), OpenApiUtils.immutable(this.parameters));
    }

    public static PathItemObjectBuilder pathItemObject() {
        return new PathItemObjectBuilder();
    }

    String summary() {
        return this.summary;
    }

    String description() {
        return this.description;
    }

    public Map<String, OperationObject> operations() {
        return this.operations;
    }

    List<ServerObject> servers() {
        return this.servers;
    }

    List<ParameterObject> parameters() {
        return this.parameters;
    }
}

