/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.OperationObject;
import io.muserver.openapi.PathItemObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class PathsObject
implements JsonWriter {
    private final Map<String, PathItemObject> pathItemObjects;

    PathsObject(Map<String, PathItemObject> pathItemObjects) {
        if (pathItemObjects != null) {
            for (String path : pathItemObjects.keySet()) {
                if (path.startsWith("/")) continue;
                throw new IllegalArgumentException("Each path must start with a '/' but got '" + path + "' from " + pathItemObjects);
            }
            HashSet<String> ids = new HashSet<String>();
            for (PathItemObject pathItemObject : pathItemObjects.values()) {
                if (pathItemObject.operations() == null) continue;
                for (OperationObject oo : pathItemObject.operations().values()) {
                    if (oo.operationId() == null) continue;
                    if (ids.contains(oo.operationId())) {
                        throw new IllegalArgumentException("Cannot have duplicate operation IDs, but got " + oo.operationId());
                    }
                    ids.add(oo.operationId());
                }
            }
            this.pathItemObjects = new LinkedHashMap<String, PathItemObject>(pathItemObjects.size());
            for (Map.Entry entry : pathItemObjects.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList())) {
                this.pathItemObjects.put((String)entry.getKey(), (PathItemObject)entry.getValue());
            }
        } else {
            this.pathItemObjects = null;
        }
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.append('{');
        boolean isFirst = true;
        if (this.pathItemObjects != null) {
            for (Map.Entry<String, PathItemObject> entry : this.pathItemObjects.entrySet()) {
                isFirst = Jsonizer.append(writer, entry.getKey(), entry.getValue(), isFirst);
            }
        }
        writer.append('}');
    }

    public Map<String, PathItemObject> pathItemObjects() {
        return this.pathItemObjects;
    }
}

