/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.HeaderObject;
import io.muserver.openapi.LinkObject;
import io.muserver.openapi.MediaTypeObject;
import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.ResponseObject;
import java.util.HashMap;
import java.util.Map;

public class ResponseObjectBuilder {
    private String description;
    private Map<String, HeaderObject> headers;
    private Map<String, MediaTypeObject> content;
    private Map<String, LinkObject> links;

    public ResponseObjectBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ResponseObjectBuilder withHeaders(Map<String, HeaderObject> headers) {
        this.headers = headers;
        return this;
    }

    public ResponseObjectBuilder withContent(Map<String, MediaTypeObject> content) {
        this.content = content;
        return this;
    }

    public ResponseObjectBuilder withLinks(Map<String, LinkObject> links) {
        this.links = links;
        return this;
    }

    public ResponseObject build() {
        return new ResponseObject(this.description, OpenApiUtils.immutable(this.headers), OpenApiUtils.immutable(this.content), OpenApiUtils.immutable(this.links));
    }

    public static ResponseObjectBuilder responseObject() {
        return new ResponseObjectBuilder();
    }

    public static ResponseObjectBuilder mergeResponses(ResponseObject primary, ResponseObject secondary) {
        HashMap<String, HeaderObject> mergedHeaders = new HashMap<String, HeaderObject>();
        ResponseObjectBuilder.addHeaders(mergedHeaders, primary);
        ResponseObjectBuilder.addHeaders(mergedHeaders, secondary);
        HashMap<String, MediaTypeObject> mergedContent = new HashMap<String, MediaTypeObject>();
        ResponseObjectBuilder.addContent(mergedContent, primary);
        ResponseObjectBuilder.addContent(mergedContent, secondary);
        HashMap<String, LinkObject> mergedLinks = new HashMap<String, LinkObject>();
        ResponseObjectBuilder.addLinks(mergedLinks, primary);
        ResponseObjectBuilder.addLinks(mergedLinks, secondary);
        return ResponseObjectBuilder.responseObject().withDescription(primary != null ? primary.description() : (secondary != null ? secondary.description() : null)).withHeaders(mergedHeaders.isEmpty() ? null : mergedHeaders).withContent(mergedContent.isEmpty() ? null : mergedContent).withLinks(mergedLinks.isEmpty() ? null : mergedLinks);
    }

    private static void addLinks(Map<String, LinkObject> dest, ResponseObject source) {
        if (source != null && source.links() != null) {
            for (Map.Entry<String, LinkObject> entry : source.links().entrySet()) {
                String name = entry.getKey();
                if (dest.containsKey(name)) continue;
                dest.put(name, entry.getValue());
            }
        }
    }

    private static void addContent(Map<String, MediaTypeObject> dest, ResponseObject source) {
        if (source != null && source.content() != null) {
            for (Map.Entry<String, MediaTypeObject> entry : source.content().entrySet()) {
                String name = entry.getKey();
                if (dest.containsKey(name)) continue;
                dest.put(name, entry.getValue());
            }
        }
    }

    private static void addHeaders(Map<String, HeaderObject> dest, ResponseObject source) {
        if (source != null && source.headers() != null) {
            for (Map.Entry<String, HeaderObject> entry : source.headers().entrySet()) {
                String name = entry.getKey();
                if (dest.containsKey(name)) continue;
                dest.put(name, entry.getValue());
            }
        }
    }
}

