/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.Mutils;
import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.ResponseObject;
import io.muserver.openapi.ResponseObjectBuilder;
import io.muserver.openapi.ResponsesObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ResponsesObjectBuilder {
    private ResponseObject defaultValue;
    private Map<String, ResponseObject> httpStatusCodes;

    public ResponsesObjectBuilder withDefaultValue(ResponseObject defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ResponsesObjectBuilder withHttpStatusCodes(Map<String, ResponseObject> httpStatusCodes) {
        this.httpStatusCodes = httpStatusCodes;
        return this;
    }

    public ResponsesObject build() {
        return new ResponsesObject(this.defaultValue, OpenApiUtils.immutable(this.httpStatusCodes));
    }

    public static ResponsesObjectBuilder responsesObject() {
        return new ResponsesObjectBuilder();
    }

    public static ResponsesObjectBuilder mergeResponses(ResponsesObject primary, ResponsesObject secondary) {
        HashSet<String> allCodes = new HashSet<String>(primary.httpStatusCodes().keySet());
        allCodes.addAll(secondary.httpStatusCodes().keySet());
        HashMap<String, ResponseObject> mergedStatusCodes = new HashMap<String, ResponseObject>();
        for (String code : allCodes) {
            mergedStatusCodes.put(code, ResponseObjectBuilder.mergeResponses(primary.httpStatusCodes().get(code), secondary.httpStatusCodes().get(code)).build());
        }
        return ResponsesObjectBuilder.responsesObject().withHttpStatusCodes(mergedStatusCodes).withDefaultValue(Mutils.coalesce(primary.defaultValue(), secondary.defaultValue()));
    }
}

