/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.Mutils;
import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.OAuthFlowsObject;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

public class SecuritySchemeObject
implements JsonWriter {
    private static final List<String> validTypes = Arrays.asList("apiKey", "http", "oauth2", "openIdConnect");
    private final String type;
    private final String description;
    private final String name;
    private final String in;
    private final String scheme;
    private final String bearerFormat;
    private final OAuthFlowsObject flows;
    private final URI openIdConnectUrl;

    SecuritySchemeObject(String type, String description, String name, String in, String scheme, String bearerFormat, OAuthFlowsObject flows, URI openIdConnectUrl) {
        Mutils.notNull("type", type);
        if (!validTypes.contains(type)) {
            throw new IllegalArgumentException("'type' must be one of " + validTypes + " but was " + type);
        }
        switch (type) {
            case "apiKey": {
                Mutils.notNull("name", name);
                Mutils.notNull("in", in);
                break;
            }
            case "http": {
                Mutils.notNull("scheme", scheme);
                break;
            }
            case "oauth2": {
                Mutils.notNull("flows", flows);
                break;
            }
            case "openIdConnect": {
                Mutils.notNull("openIdConnectUrl", openIdConnectUrl);
            }
        }
        this.type = type;
        this.description = description;
        this.name = name;
        this.in = in;
        this.scheme = scheme;
        this.bearerFormat = bearerFormat;
        this.flows = flows;
        this.openIdConnectUrl = openIdConnectUrl;
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.write(123);
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "type", this.type, isFirst);
        isFirst = Jsonizer.append(writer, "description", this.description, isFirst);
        isFirst = Jsonizer.append(writer, "name", this.name, isFirst);
        isFirst = Jsonizer.append(writer, "in", this.in, isFirst);
        isFirst = Jsonizer.append(writer, "scheme", this.scheme, isFirst);
        isFirst = Jsonizer.append(writer, "bearerFormat", this.bearerFormat, isFirst);
        isFirst = Jsonizer.append(writer, "flows", this.flows, isFirst);
        isFirst = Jsonizer.append(writer, "openIdConnectUrl", this.openIdConnectUrl, isFirst);
        writer.write(125);
    }

    public String type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public String in() {
        return this.in;
    }

    public String scheme() {
        return this.scheme;
    }

    public String bearerFormat() {
        return this.bearerFormat;
    }

    public OAuthFlowsObject flows() {
        return this.flows;
    }

    public URI openIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    public static List<String> validTypes() {
        return validTypes;
    }
}

