/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.OAuthFlowsObject;
import io.muserver.openapi.SecuritySchemeObject;
import java.net.URI;

public class SecuritySchemeObjectBuilder {
    private String type;
    private String description;
    private String name;
    private String in;
    private String scheme;
    private String bearerFormat;
    private OAuthFlowsObject flows;
    private URI openIdConnectUrl;

    public SecuritySchemeObjectBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public SecuritySchemeObjectBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public SecuritySchemeObjectBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public SecuritySchemeObjectBuilder withIn(String in) {
        this.in = in;
        return this;
    }

    public SecuritySchemeObjectBuilder withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public SecuritySchemeObjectBuilder withBearerFormat(String bearerFormat) {
        this.bearerFormat = bearerFormat;
        return this;
    }

    public SecuritySchemeObjectBuilder withFlows(OAuthFlowsObject flows) {
        this.flows = flows;
        return this;
    }

    public SecuritySchemeObjectBuilder withOpenIdConnectUrl(URI openIdConnectUrl) {
        this.openIdConnectUrl = openIdConnectUrl;
        return this;
    }

    public SecuritySchemeObject build() {
        return new SecuritySchemeObject(this.type, this.description, this.name, this.in, this.scheme, this.bearerFormat, this.flows, this.openIdConnectUrl);
    }

    public static SecuritySchemeObjectBuilder securitySchemeObject() {
        return new SecuritySchemeObjectBuilder();
    }
}

