/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.AsyncHandle;
import io.muserver.HeaderNames;
import io.muserver.Mutils;
import io.muserver.ResponseCompleteListener;
import io.muserver.ResponseInfo;
import io.muserver.rest.NotImplementedException;
import io.netty.util.concurrent.DefaultThreadFactory;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.container.ConnectionCallback;
import jakarta.ws.rs.container.TimeoutHandler;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncResponseAdapter
implements AsyncResponse,
ResponseCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(AsyncResponseAdapter.class);
    private static final ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("mutimeoutwatcher"));
    private final AsyncHandle asyncHandle;
    private final Consumer resultConsumer;
    private volatile boolean isSuspended;
    private volatile boolean isCancelled;
    private volatile boolean isDone;
    private volatile ScheduledFuture<?> cancelEvent;
    private volatile TimeoutHandler timeoutHandler;
    private final List<ConnectionCallback> connectionCallbacks = new ArrayList<ConnectionCallback>();
    private final List<CompletionCallback> completionCallbacks = new ArrayList<CompletionCallback>();
    private Throwable exceptionWhileWriting = null;

    AsyncResponseAdapter(AsyncHandle asyncHandle, Consumer resultConsumer) {
        this.asyncHandle = asyncHandle;
        this.isSuspended = true;
        this.isCancelled = false;
        this.isDone = false;
        this.resultConsumer = resultConsumer;
        asyncHandle.addResponseCompleteHandler(this);
    }

    public boolean resume(Object response) {
        if (this.cancelEvent != null) {
            this.isCancelled = this.isCancelled || this.cancelEvent.cancel(false);
            this.cancelEvent = null;
        }
        if (this.isSuspended) {
            this.isSuspended = false;
            try {
                this.resultConsumer.accept(response);
                this.asyncHandle.complete();
            }
            catch (Exception e) {
                this.exceptionWhileWriting = e;
                this.asyncHandle.complete(e);
            }
            finally {
                this.isDone = true;
            }
            return true;
        }
        return false;
    }

    public boolean resume(Throwable response) {
        return this.resume((Object)response);
    }

    public boolean cancel() {
        return this.doCancel(null);
    }

    public boolean cancel(int retryAfter) {
        return this.doCancel(retryAfter);
    }

    public boolean cancel(Date retryAfter) {
        return this.doCancel(Mutils.toHttpDate(retryAfter));
    }

    private boolean doCancel(Object retryAfterValue) {
        Response.ResponseBuilder resp = Response.status((int)503);
        if (retryAfterValue != null) {
            resp.header(HeaderNames.RETRY_AFTER.toString(), retryAfterValue);
        }
        return this.resume(resp.build());
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public boolean setTimeout(long time, TimeUnit unit) {
        if (!this.isSuspended) {
            return false;
        }
        if (this.cancelEvent != null) {
            this.cancelEvent.cancel(false);
        }
        this.cancelEvent = ses.schedule(() -> {
            TimeoutHandler th = this.timeoutHandler;
            if (th == null) {
                this.resume(new WebApplicationException(Response.status((int)503).type(MediaType.TEXT_HTML_TYPE).entity((Object)"<h1>503 Service Unavailable</h1><p>Timed out</p>").build()));
            } else {
                th.handleTimeout((AsyncResponse)this);
            }
        }, time, unit);
        return true;
    }

    public void setTimeoutHandler(TimeoutHandler handler) {
        this.timeoutHandler = handler;
    }

    public Collection<Class<?>> register(Class<?> callback) {
        throw new NotImplementedException("Mu-Server does not instantiate classes for you. Please use register(Object) with an instantiated callback instead.");
    }

    public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
        throw new NotImplementedException("Mu-Server does not instantiate classes for you. Please use register(Object, Object...) with instantiated callbacks instead.");
    }

    public Collection<Class<?>> register(Object callback) {
        HashSet added = new HashSet();
        if (callback instanceof ConnectionCallback) {
            added.add(ConnectionCallback.class);
            this.connectionCallbacks.add((ConnectionCallback)callback);
        }
        if (callback instanceof CompletionCallback) {
            added.add(CompletionCallback.class);
            this.completionCallbacks.add((CompletionCallback)callback);
        }
        return added;
    }

    public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
        HashMap added = new HashMap();
        this.register(callback, added);
        for (Object cb : callbacks) {
            this.register(cb, added);
        }
        return added;
    }

    private void register(Object callback, Map<Class<?>, Collection<Class<?>>> added) {
        Collection<Class<?>> registered = this.register(callback);
        Class<?> callbackClass = callback.getClass();
        if (!added.containsKey(callbackClass)) {
            added.put(callbackClass, new HashSet());
        }
        added.get(callbackClass).addAll(registered);
    }

    @Override
    public void onComplete(ResponseInfo info) {
        if (!info.completedSuccessfully()) {
            for (ConnectionCallback connectionCallback : this.connectionCallbacks) {
                try {
                    connectionCallback.onDisconnect((AsyncResponse)this);
                }
                catch (Exception e) {
                    log.warn("Exception from calling onDisconnect on " + connectionCallback);
                }
            }
        }
        for (CompletionCallback completionCallback : this.completionCallbacks) {
            try {
                completionCallback.onComplete(this.exceptionWhileWriting);
            }
            catch (Exception e) {
                log.warn("Exception from calling onComplete on " + completionCallback);
            }
        }
    }

    static interface Consumer {
        public void accept(Object var1) throws Exception;
    }
}

