/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Mutils;
import io.muserver.rest.Authorizer;
import io.muserver.rest.MuRuntimeDelegate;
import io.muserver.rest.MuSecurityContext;
import io.muserver.rest.UserPassAuthenticator;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;

public class BasicAuthSecurityFilter
implements ContainerRequestFilter {
    private Response.ResponseBuilder authResponse;
    private final UserPassAuthenticator authenticator;
    private final Authorizer authorizer;

    public BasicAuthSecurityFilter(String authRealm, UserPassAuthenticator authenticator, Authorizer authorizer) {
        Mutils.notNull("authenticator", authenticator);
        Mutils.notNull("authorizer", authorizer);
        Mutils.notNull("authRealm", authRealm);
        if (authRealm.contains("\"")) {
            throw new IllegalArgumentException("authRealm cannot contain a double quote");
        }
        this.authenticator = authenticator;
        this.authorizer = authorizer;
        this.authResponse = Response.status((int)401).entity((Object)"401 Unauthorized").type(MediaType.TEXT_PLAIN_TYPE).header("WWW-Authenticate", (Object)("Basic realm=\"" + authRealm + "\""));
    }

    public void filter(ContainerRequestContext filterContext) throws IOException {
        String authorization = filterContext.getHeaderString("Authorization");
        if (authorization == null || !authorization.startsWith("Basic ")) {
            filterContext.abortWith(this.authResponse.build());
            return;
        }
        String base64Encoded = authorization.substring("Basic ".length());
        String decoded = new String(Base64.getDecoder().decode(base64Encoded), "UTF-8");
        String[] userPass = decoded.split(":", 2);
        if (userPass.length != 2) {
            filterContext.abortWith(Response.status((int)400).entity((Object)"An invalid Authorization header was used").build());
            return;
        }
        Principal principal = this.authenticator.authenticate(userPass[0], userPass[1]);
        boolean isHttps = "https".equalsIgnoreCase(filterContext.getUriInfo().getRequestUri().getScheme());
        MuSecurityContext securityContext = principal == null ? (isHttps ? MuSecurityContext.notLoggedInHttpsContext : MuSecurityContext.notLoggedInHttpContext) : new MuSecurityContext(principal, this.authorizer, isHttps, "BASIC");
        filterContext.setSecurityContext((SecurityContext)securityContext);
    }

    static {
        MuRuntimeDelegate.ensureSet();
    }
}

