/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Mutils;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;

class BinaryEntityProviders {
    static final List<MessageBodyReader> binaryEntityReaders = Arrays.asList(new InputStreamReader(), new ByteArrayReaderWriter(), new FileReaderWriter());
    static final List<MessageBodyWriter> binaryEntityWriters = Arrays.asList(new StreamingOutputWriter(), new ByteArrayReaderWriter(), new FileReaderWriter(), new InputStreamPiper());

    BinaryEntityProviders() {
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    static class FileReaderWriter
    implements MessageBodyReader<File>,
    MessageBodyWriter<File> {
        FileReaderWriter() {
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return File.class.isAssignableFrom(type);
        }

        public File readFrom(Class<File> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            File temp = Files.createTempFile("MuServer", "tmp", new FileAttribute[0]).toFile();
            temp.deleteOnExit();
            try (FileOutputStream fileWriter = new FileOutputStream(temp);){
                Mutils.copy(entityStream, fileWriter, 8192);
            }
            return temp;
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return File.class.isAssignableFrom(type);
        }

        public long getSize(File file, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return file.length();
        }

        public void writeTo(File file, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Mutils.copy(fileInputStream, entityStream, 8192);
            }
        }
    }

    @Consumes(value={"*/*"})
    static class InputStreamPiper
    implements MessageBodyWriter<InputStream> {
        InputStreamPiper() {
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return InputStream.class.isAssignableFrom(type);
        }

        public void writeTo(InputStream inputStream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            Mutils.copy(inputStream, entityStream, 8192);
        }
    }

    @Consumes(value={"*/*"})
    static class InputStreamReader
    implements MessageBodyReader<InputStream> {
        InputStreamReader() {
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return InputStream.class.isAssignableFrom(type);
        }

        public InputStream readFrom(Class<InputStream> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return entityStream;
        }
    }

    @Produces(value={"*/*"})
    static class StreamingOutputWriter
    implements MessageBodyWriter<StreamingOutput> {
        StreamingOutputWriter() {
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return StreamingOutput.class.isAssignableFrom(type);
        }

        public void writeTo(StreamingOutput streamingOutput, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            streamingOutput.write(entityStream);
        }
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    static class ByteArrayReaderWriter
    implements MessageBodyReader<byte[]>,
    MessageBodyWriter<byte[]> {
        ByteArrayReaderWriter() {
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return type.isArray() && type.getComponentType().equals(Byte.TYPE);
        }

        public byte[] readFrom(Class<byte[]> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return Mutils.toByteArray(entityStream, 2048);
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return type.isArray() && type.getComponentType().equals(Byte.TYPE);
        }

        public long getSize(byte[] bytes, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return bytes.length;
        }

        public void writeTo(byte[] bytes, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(bytes);
        }
    }
}

