/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Cookie;
import io.muserver.Mutils;
import io.muserver.UploadedFile;
import io.muserver.rest.MuPathSegment;
import io.muserver.rest.MuUriInfo;
import io.muserver.rest.ResourceMethodParam;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class BuiltInParamConverterProvider
implements ParamConverterProvider {
    private final ParamConverter<String> stringParamConverter = new ParamConverter<String>(){

        public String fromString(String value) {
            return value;
        }

        public String toString(String value) {
            return value;
        }
    };
    private static final List<PrimitiveConverter> primitiveConverters = Arrays.asList(new PrimitiveConverter<Integer>(Integer.TYPE, 0, Integer::parseInt), new PrimitiveConverter<Long>(Long.TYPE, 0L, Long::parseLong), new PrimitiveConverter<Short>(Short.TYPE, (short)0, Short::parseShort), new PrimitiveConverter<Character>(Character.TYPE, Character.valueOf('\u0000'), s -> Character.valueOf(s.charAt(0))), new PrimitiveConverter<Byte>(Byte.TYPE, (byte)0, Byte::parseByte), new PrimitiveConverter<Float>(Float.TYPE, Float.valueOf(0.0f), Float::parseFloat), new PrimitiveConverter<Double>(Double.TYPE, 0.0, Double::parseDouble), new PrimitiveConverter<Boolean>(Boolean.TYPE, false, Boolean::parseBoolean));
    private static final List<BoxedPrimitiveConverter> boxedPrimitiveConverters = Arrays.asList(new BoxedPrimitiveConverter<Integer>(Integer.class, Integer::parseInt), new BoxedPrimitiveConverter<Long>(Long.class, Long::parseLong), new BoxedPrimitiveConverter<Short>(Short.class, Short::parseShort), new BoxedPrimitiveConverter<Character>(Character.class, s -> Character.valueOf(s.charAt(0))), new BoxedPrimitiveConverter<Byte>(Byte.class, Byte::parseByte), new BoxedPrimitiveConverter<Float>(Float.class, Float::parseFloat), new BoxedPrimitiveConverter<Double>(Double.class, Double::parseDouble), new BoxedPrimitiveConverter<Boolean>(Boolean.class, Boolean::parseBoolean));

    BuiltInParamConverterProvider() {
    }

    public <T> ParamConverter getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (String.class.isAssignableFrom(rawType)) {
            return this.stringParamConverter;
        }
        for (PrimitiveConverter primitiveConverter : primitiveConverters) {
            if (!primitiveConverter.primitiveClass.equals(rawType)) continue;
            return primitiveConverter;
        }
        for (BoxedPrimitiveConverter boxedPrimitiveConverter : boxedPrimitiveConverters) {
            if (!boxedPrimitiveConverter.boxedClass.isAssignableFrom(rawType)) continue;
            return boxedPrimitiveConverter;
        }
        if (UploadedFile.class.isAssignableFrom(rawType)) {
            return new UploadedFileConverter();
        }
        if (PathSegment.class.isAssignableFrom(rawType)) {
            return new PathSegmentConverter();
        }
        if (Cookie.class.isAssignableFrom(rawType)) {
            return new DummyCookieConverter();
        }
        if (rawType.isEnum()) {
            return new EnumConverter(rawType);
        }
        ConstructorConverter<T> cc = ConstructorConverter.tryToCreate(rawType);
        if (cc != null) {
            return cc;
        }
        StaticMethodConverter staticMethodConverter = StaticMethodConverter.tryToCreate(rawType);
        return staticMethodConverter;
    }

    private static class StaticMethodConverter<T>
    implements ParamConverter<T> {
        private final Method staticMethod;

        private StaticMethodConverter(Method staticMethod) {
            this.staticMethod = staticMethod;
        }

        public T fromString(String value) {
            if (Mutils.nullOrEmpty(value)) {
                return null;
            }
            try {
                return (T)this.staticMethod.invoke(null, value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not convert \"" + value + "\" to a " + this.staticMethod.getDeclaringClass().getSimpleName() + " because " + e.getMessage(), e);
            }
        }

        public String toString(T value) {
            return String.valueOf(value);
        }

        public String toString() {
            return this.staticMethod.toString();
        }

        static <T> StaticMethodConverter<T> tryToCreate(Class clazz) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            Method staticMethod = StaticMethodConverter.getSingleParamPublicStaticMethodNamed(clazz, declaredMethods, "valueOf");
            if (staticMethod == null) {
                staticMethod = StaticMethodConverter.getSingleParamPublicStaticMethodNamed(clazz, declaredMethods, "fromString");
            }
            if (staticMethod == null) {
                staticMethod = StaticMethodConverter.getSingleParamPublicStaticMethodNamed(clazz, declaredMethods, "parse");
            }
            if (staticMethod == null) {
                return null;
            }
            staticMethod.setAccessible(true);
            return new StaticMethodConverter<T>(staticMethod);
        }

        private static Method getSingleParamPublicStaticMethodNamed(Class clazz, Method[] declaredMethods, String name) {
            Method staticMethod = null;
            for (Method method : declaredMethods) {
                int modifiers = method.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !method.getReturnType().equals(clazz) || !method.getName().equals(name) || method.getParameterCount() != 1 || !CharSequence.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
                staticMethod = method;
                break;
            }
            return staticMethod;
        }
    }

    private static class ConstructorConverter<T>
    implements ParamConverter<T> {
        private final Constructor<T> constructor;

        private ConstructorConverter(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        public T fromString(String value) {
            if (Mutils.nullOrEmpty(value)) {
                return null;
            }
            try {
                return this.constructor.newInstance(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not convert \"" + value + "\" to a " + this.constructor.getDeclaringClass().getSimpleName(), e);
            }
        }

        public String toString(T value) {
            return String.valueOf(value);
        }

        public String toString() {
            return "ConstructorConverter{" + this.constructor + '}';
        }

        static <T> ConstructorConverter<T> tryToCreate(Class<T> clazz) {
            try {
                Constructor<T> constructor = clazz.getConstructor(String.class);
                int modifiers = constructor.getModifiers();
                if (Modifier.isPublic(modifiers)) {
                    constructor.setAccessible(true);
                    return new ConstructorConverter<T>(constructor);
                }
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }

    private static class EnumConverter<E extends Enum<E>>
    implements ParamConverter<E> {
        private final Class<E> enumClass;

        private EnumConverter(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        public E fromString(String value) {
            if (Mutils.nullOrEmpty(value)) {
                return null;
            }
            return Enum.valueOf(this.enumClass, value);
        }

        public String toString(E value) {
            return ((Enum)value).name();
        }

        public String toString() {
            String validValues = Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.joining(", "));
            return this.enumClass.getSimpleName() + " converter (valid values: " + validValues + ")";
        }
    }

    private static class PrimitiveConverter<T>
    implements ParamConverter<T>,
    ResourceMethodParam.HasDefaultValue {
        private final T defaultValue;
        private final Class primitiveClass;
        private final Function<String, T> stringToValue;

        public PrimitiveConverter(Class primitiveClass, T defaultValue, Function<String, T> stringToValue) {
            this.defaultValue = defaultValue;
            this.primitiveClass = primitiveClass;
            this.stringToValue = stringToValue;
        }

        public T fromString(String value) {
            if (value == null || value.isEmpty()) {
                return this.defaultValue;
            }
            return this.stringToValue.apply(value);
        }

        public String toString(T value) {
            return String.valueOf(value);
        }

        @Override
        public Object getDefault() {
            return this.defaultValue;
        }

        public String toString() {
            return this.primitiveClass.getSimpleName() + " param converter";
        }
    }

    private static class BoxedPrimitiveConverter<T>
    implements ParamConverter<T> {
        private final Class<T> boxedClass;
        private final Function<String, T> stringToValue;

        public BoxedPrimitiveConverter(Class<T> boxedClass, Function<String, T> stringToValue) {
            this.boxedClass = boxedClass;
            this.stringToValue = stringToValue;
        }

        public T fromString(String value) {
            if (Mutils.nullOrEmpty(value)) {
                return null;
            }
            return this.stringToValue.apply(value);
        }

        public String toString(T value) {
            return String.valueOf(value);
        }

        public String toString() {
            return this.boxedClass.getSimpleName() + " param converter";
        }
    }

    private static class PathSegmentConverter
    implements ParamConverter<PathSegment> {
        private PathSegmentConverter() {
        }

        public PathSegment fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            MuPathSegment seg = MuUriInfo.pathStringToSegments(value, true).findFirst().orElse(null);
            if (seg == null) {
                throw new IllegalArgumentException("Could not parse a path segment");
            }
            return seg;
        }

        public String toString(PathSegment value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            return value.toString();
        }
    }

    private static class DummyCookieConverter
    implements ParamConverter<Cookie> {
        private DummyCookieConverter() {
        }

        public Cookie fromString(String value) {
            return null;
        }

        public String toString(Cookie value) {
            return value.toString();
        }
    }

    private static class UploadedFileConverter
    implements ParamConverter<UploadedFile> {
        private UploadedFileConverter() {
        }

        public UploadedFile fromString(String value) {
            return null;
        }

        public String toString(UploadedFile value) {
            return value.filename();
        }
    }
}

