/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.Method;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.rest.RequestMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CORSConfig {
    private final boolean allowCredentials;
    private final Collection<String> allowedOrigins;
    private final List<Pattern> allowedOriginRegex;
    private final Collection<String> exposedHeaders;
    private final long maxAge;
    private final Collection<String> allowedHeaders;
    private final String exposedHeadersCSV;
    private final String allowedHeadersCSV;

    CORSConfig(boolean allowCredentials, Collection<String> allowedOrigins, List<Pattern> allowedOriginRegex, Collection<String> allowedHeaders, Collection<String> exposedHeaders, long maxAge) {
        Mutils.notNull("allowedOriginRegex", allowedOriginRegex);
        this.allowCredentials = allowCredentials;
        this.allowedOrigins = allowedOrigins == null ? null : Collections.unmodifiableCollection(allowedOrigins);
        this.allowedOriginRegex = allowedOriginRegex;
        this.maxAge = maxAge;
        this.allowedHeaders = allowedHeaders;
        this.allowedHeadersCSV = String.join((CharSequence)", ", allowedHeaders);
        this.exposedHeaders = Collections.unmodifiableCollection(exposedHeaders);
        this.exposedHeadersCSV = String.join((CharSequence)", ", exposedHeaders);
    }

    public boolean writeHeaders(MuRequest request, MuResponse response, Set<Method> allowedMethods) {
        boolean written = this.writeHeadersInternal(request, response, null);
        if (written) {
            response.headers().set(HeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Object)CORSConfig.getAllowedString(allowedMethods));
        }
        return written;
    }

    boolean writeHeadersInternal(MuRequest request, MuResponse response, Set<RequestMatcher.MatchedMethod> matchedMethodsForPath) {
        String origin;
        Headers respHeaders = response.headers();
        if (!respHeaders.containsValue(HeaderNames.VARY, HeaderNames.ORIGIN, true)) {
            respHeaders.add(HeaderNames.VARY, (Object)HeaderNames.ORIGIN);
        }
        if (Mutils.nullOrEmpty(origin = request.headers().get(HeaderNames.ORIGIN))) {
            return false;
        }
        if (this.allowCors(origin)) {
            respHeaders.set(HeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
            if (matchedMethodsForPath != null) {
                String allowed = CORSConfig.getAllowedMethods(matchedMethodsForPath);
                respHeaders.set(HeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Object)allowed);
            }
            if (request.method() == Method.OPTIONS) {
                respHeaders.set(HeaderNames.ACCESS_CONTROL_MAX_AGE, (Object)this.maxAge);
                if (!this.allowedHeaders.isEmpty()) {
                    respHeaders.set(HeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)this.allowedHeadersCSV);
                }
            }
            if (!this.exposedHeaders.isEmpty()) {
                respHeaders.set(HeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, (Object)this.exposedHeadersCSV);
            }
            if (this.allowCredentials) {
                respHeaders.set(HeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
            }
            return true;
        }
        respHeaders.remove(HeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN);
        return false;
    }

    static String getAllowedMethods(Set<RequestMatcher.MatchedMethod> matchedMethodsForPath) {
        Set<Method> methods = matchedMethodsForPath.stream().map(m -> m.resourceMethod.httpMethod).collect(Collectors.toSet());
        return CORSConfig.getAllowedString(methods);
    }

    static String getAllowedString(Set<Method> allowed) {
        if (allowed.contains((Object)Method.GET)) {
            allowed.add(Method.HEAD);
        }
        allowed.add(Method.OPTIONS);
        return allowed.stream().map(Enum::name).sorted().collect(Collectors.joining(", "));
    }

    boolean allowCors(String origin) {
        if (this.allowedOrigins == null || this.allowedOrigins.contains(origin)) {
            return true;
        }
        for (Pattern pattern : this.allowedOriginRegex) {
            if (!pattern.matcher(origin).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean allowCredentials() {
        return this.allowCredentials;
    }

    public Collection<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public List<Pattern> allowedOriginRegex() {
        return this.allowedOriginRegex;
    }

    public Collection<String> exposedHeaders() {
        return this.exposedHeaders;
    }

    public long maxAge() {
        return this.maxAge;
    }

    public Collection<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CORSConfig that = (CORSConfig)o;
        return this.allowCredentials == that.allowCredentials && this.maxAge == that.maxAge && Objects.equals(this.allowedOrigins, that.allowedOrigins) && Objects.equals(this.allowedOriginRegex, that.allowedOriginRegex) && Objects.equals(this.exposedHeaders, that.exposedHeaders) && Objects.equals(this.allowedHeaders, that.allowedHeaders) && Objects.equals(this.exposedHeadersCSV, that.exposedHeadersCSV) && Objects.equals(this.allowedHeadersCSV, that.allowedHeadersCSV);
    }

    public int hashCode() {
        return Objects.hash(this.allowCredentials, this.allowedOrigins, this.allowedOriginRegex, this.exposedHeaders, this.maxAge, this.allowedHeaders, this.exposedHeadersCSV, this.allowedHeadersCSV);
    }

    public String toString() {
        return "CORSConfig{allowCredentials=" + this.allowCredentials + ", allowedOrigins=" + this.allowedOrigins + ", allowedOriginRegex=" + this.allowedOriginRegex + ", exposedHeaders=" + this.exposedHeaders + ", maxAge=" + this.maxAge + ", allowedHeaders=" + this.allowedHeaders + ", exposedHeadersCSV='" + this.exposedHeadersCSV + '\'' + ", allowedHeadersCSV='" + this.allowedHeadersCSV + '\'' + '}';
    }
}

