/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.rest.JaxRSRequest;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomExceptionMapper {
    private static final Logger log = LoggerFactory.getLogger(CustomExceptionMapper.class);
    private final Map<Class<? extends Throwable>, ExceptionMapper<? extends Throwable>> mappers;

    CustomExceptionMapper(Map<Class<? extends Throwable>, ExceptionMapper<? extends Throwable>> mappers) {
        this.mappers = new HashMap<Class<? extends Throwable>, ExceptionMapper<? extends Throwable>>(mappers);
    }

    Response toResponse(Throwable ex) {
        Class<?> exClass = ex.getClass();
        if (exClass.equals(JaxRSRequest.FilterAbortedException.class)) {
            return ((JaxRSRequest.FilterAbortedException)((Object)ex)).getResponse();
        }
        int maxDepth = Integer.MAX_VALUE;
        ExceptionMapper exceptionMapper = this.findBestMatchingExceptionMapper(exClass, maxDepth);
        if (exceptionMapper == null) {
            return null;
        }
        try {
            Response response = exceptionMapper.toResponse(ex);
            if (response == null) {
                response = Response.noContent().build();
            }
            return response;
        }
        catch (Exception e) {
            String errorID = UUID.randomUUID().toString();
            log.error("Error thrown from exception mapper " + exceptionMapper + " so returning error to client with ErrorID=" + errorID, (Throwable)e);
            return Response.serverError().type(MediaType.TEXT_HTML_TYPE).entity((Object)("<h1>500 Internal Server Error</h1><p>ErrorID=" + errorID + "</p>")).build();
        }
    }

    private ExceptionMapper findBestMatchingExceptionMapper(Class<? extends Throwable> exClass, int maxDepth) {
        ExceptionMapper<? extends Throwable> exceptionMapper = null;
        block0: for (Map.Entry<Class<? extends Throwable>, ExceptionMapper<? extends Throwable>> entry : this.mappers.entrySet()) {
            Class<? extends Throwable> mapperClass = entry.getKey();
            if (!mapperClass.isAssignableFrom(exClass)) continue;
            int depth = 0;
            for (Class<? extends Throwable> yo = exClass; yo != null; yo = yo.getSuperclass()) {
                if (mapperClass.equals(yo)) {
                    if (depth >= maxDepth) continue block0;
                    maxDepth = depth;
                    exceptionMapper = entry.getValue();
                    continue block0;
                }
                ++depth;
            }
        }
        return exceptionMapper;
    }
}

