/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Mutils;
import io.muserver.openapi.ContactObject;
import io.muserver.openapi.ExampleObject;
import io.muserver.openapi.ExternalDocumentationObject;
import io.muserver.openapi.LicenseObject;
import io.muserver.openapi.MediaTypeObject;
import io.muserver.openapi.OpenAPIObject;
import io.muserver.openapi.OperationObject;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.PathItemObject;
import io.muserver.openapi.RequestBodyObject;
import io.muserver.openapi.ResponseObject;
import io.muserver.openapi.SchemaObject;
import io.muserver.openapi.TagObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HtmlDocumentor {
    private final BufferedWriter writer;
    private final OpenAPIObject api;
    private final String css;
    private final URI requestUri;

    HtmlDocumentor(BufferedWriter writer, OpenAPIObject api, String css, URI requestUri) {
        this.writer = writer;
        this.api = api;
        this.css = css;
        this.requestUri = requestUri;
    }

    void writeHtml() throws IOException {
        LicenseObject license;
        this.writer.write("<!DOCTYPE html>\n");
        El html = new El("html").open();
        El head = new El("head").open();
        this.render("title", this.api.info().title());
        new El("style").open().contentRaw(this.css).close();
        head.close();
        El body = new El("body").open();
        new El("h1").open().content(this.api.info().title()).close();
        El preamble = new El("div").open(Collections.singletonMap("class", "preamble"));
        this.renderIfValue("p", this.api.info().description());
        this.renderExternalLinksParagraph(this.api.externalDocs());
        El metaData = new El("p").open(Collections.singletonMap("class", "apiMetaData"));
        metaData.content("Version " + this.api.info().version());
        if (this.api.info().contact() != null) {
            ContactObject contact = this.api.info().contact();
            metaData.content(" | Contact: ");
            if (contact.url() != null) {
                String contactName = contact.name() == null ? contact.url().toString() : contact.name();
                new El("a").open(Collections.singletonMap("href", contact.url().toString())).content(contactName).close();
            } else if (contact.name() != null) {
                metaData.content(" " + contact.name());
            }
            if (contact.email() != null) {
                metaData.content(" | ");
                new El("a").open(Collections.singletonMap("href", "mailto:" + contact.email())).content(contact.email()).close();
            }
        }
        if ((license = this.api.info().license()) != null) {
            metaData.content(" | License: ");
            String name = license.name() == null ? license.url().toString() : license.name();
            new El("a").open(Collections.singletonMap("href", "mailto:" + license.url())).content(name).close();
        }
        if (this.api.info().termsOfService() != null) {
            metaData.content(" | ");
            new El("a").open(Collections.singletonMap("href", this.api.info().termsOfService().toString())).content("Terms of service").close();
        }
        String baseUri = "";
        if (this.api.servers() != null && !this.api.servers().isEmpty()) {
            baseUri = this.api.servers().get(0).url();
        }
        preamble.close();
        El nav = new El("ul").open(Collections.singletonMap("class", "nav operation"));
        for (TagObject tag : this.api.tags()) {
            El li = new El("li").open();
            new El("a").open(Collections.singletonMap("href", "#" + Mutils.htmlEncode(tag.name()))).content(tag.name()).close();
            El subNav = new El("ul").open(Collections.singletonMap("class", "subNav"));
            for (Map.Entry<String, PathItemObject> entry : this.api.paths().pathItemObjects().entrySet()) {
                String url = entry.getKey();
                PathItemObject item = entry.getValue();
                for (Map.Entry<String, OperationObject> operationObjectEntry : item.operations().entrySet()) {
                    String method = operationObjectEntry.getKey();
                    OperationObject operation = operationObjectEntry.getValue();
                    if (!operation.tags().contains(tag.name())) continue;
                    El subNavLi = new El("li").open();
                    new El("a").open(Collections.singletonMap("href", "#" + Mutils.htmlEncode(operation.operationId()))).content(method.toUpperCase() + " " + url).close();
                    subNavLi.close();
                }
            }
            subNav.close();
            li.close();
        }
        nav.close();
        for (TagObject tag : this.api.tags()) {
            El tagContainer = new El("div").open(Collections.singletonMap("class", "tagContainer"));
            new El("h2").open(Collections.singletonMap("id", Mutils.htmlEncode(tag.name()))).content(tag.name()).close();
            this.renderIfValue("p", tag.description());
            this.renderExternalLinksParagraph(tag.externalDocs());
            for (Map.Entry<String, PathItemObject> entry : this.api.paths().pathItemObjects().entrySet()) {
                String url = entry.getKey();
                PathItemObject item = entry.getValue();
                for (Map.Entry<String, OperationObject> operationObjectEntry : item.operations().entrySet()) {
                    String method = operationObjectEntry.getKey();
                    OperationObject operation = operationObjectEntry.getValue();
                    if (!operation.tags().contains(tag.name())) continue;
                    HashMap<String, String> operationAttributes = new HashMap<String, String>();
                    operationAttributes.put("id", Mutils.htmlEncode(operation.operationId()));
                    operationAttributes.put("class", "operation");
                    El operationDiv = new El("div").open(operationAttributes);
                    El h3 = new El("h3").open().content(method.toUpperCase() + " ");
                    String urlWithContext = baseUri + url;
                    new El("a").open(Collections.singletonMap("href", urlWithContext)).content(url).close();
                    h3.close();
                    this.renderIfValue("p", operation.summary());
                    this.renderIfValue("p", operation.description());
                    this.renderExternalLinksParagraph(operation.externalDocs());
                    if (operation.isDeprecated()) {
                        new El("p").open(Collections.singletonMap("class", "deprecated")).content("WARNING: This operation is marked as deprecated and may not be supported in future versions of this API.").close();
                    }
                    StringBuilder queryString = new StringBuilder();
                    StringBuilder curlHeaders = new StringBuilder();
                    RequestBodyObject requestBody = operation.requestBody();
                    if (!operation.parameters().isEmpty()) {
                        this.render("h4", "Parameters");
                        El table = new El("table").open(Collections.singletonMap("class", "parameterTable"));
                        El thead = new El("thead").open();
                        El el = new El("tr").open();
                        this.render("th", "Name");
                        this.render("th", "Type");
                        this.render("th", "Description");
                        el.close();
                        thead.close();
                        El tbody = new El("tbody").open();
                        for (ParameterObject parameter : operation.parameters()) {
                            El row = new El("tr").open();
                            this.render("td", parameter.name());
                            String type = parameter.in();
                            if ("query".equals(type)) {
                                queryString.append(queryString.length() == 0 ? (char)'?' : '&');
                                queryString.append(Mutils.urlEncode(parameter.name())).append('=').append(Mutils.urlEncode(HtmlDocumentor.bashValue(parameter.example())));
                            } else if ("header".equals(type)) {
                                curlHeaders.append(" -H '").append(parameter.name()).append(": ").append(HtmlDocumentor.bashValue(parameter.example())).append('\'');
                            }
                            SchemaObject schema = parameter.schema();
                            Object defaultVal = null;
                            ExternalDocumentationObject externalDocs = null;
                            if (schema != null) {
                                type = type + " - " + schema.type();
                                if (schema.format() != null) {
                                    type = type + " (" + schema.format() + ")";
                                }
                                defaultVal = schema.defaultValue();
                                externalDocs = schema.externalDocs();
                            }
                            this.render("td", type);
                            El paramDesc = new El("td").open();
                            if (parameter.deprecated()) {
                                this.render("strong", "DEPRECATED. ");
                            }
                            if (parameter.required()) {
                                this.render("strong", "REQUIRED. ");
                            }
                            paramDesc.content(parameter.description());
                            this.renderExamples(parameter.example(), parameter.examples(), defaultVal);
                            this.renderExternalLinksParagraph(externalDocs);
                            paramDesc.close();
                            row.close();
                        }
                        tbody.close();
                        table.close();
                    }
                    StringBuilder curlBody = new StringBuilder();
                    if (requestBody != null) {
                        this.render("h4", "Request body");
                        this.renderIfValue("p", requestBody.description());
                        for (Map.Entry entry2 : requestBody.content().entrySet()) {
                            String curlFormParam;
                            String mediaType = (String)entry2.getKey();
                            MediaTypeObject value = (MediaTypeObject)entry2.getValue();
                            this.render("h5", mediaType);
                            this.renderExamples(value.example(), value.examples(), value.schema() == null ? null : value.schema().defaultValue());
                            String string = curlFormParam = mediaType.equalsIgnoreCase("multipart/form-data") ? "-F" : "-d";
                            if (curlBody.length() == 0) {
                                curlBody = new StringBuilder(" -H 'content-type: " + mediaType + "'");
                            }
                            if (value.schema() == null || value.schema().properties() == null) {
                                curlBody.append(" --data '").append(HtmlDocumentor.bashValue(value.example())).append("'");
                                continue;
                            }
                            El table = new El("table").open(Collections.singletonMap("class", "parameterTable"));
                            El thead = new El("thead").open();
                            El theadRow = new El("tr").open();
                            this.render("th", "Name");
                            this.render("th", "Type");
                            this.render("th", "Description");
                            theadRow.close();
                            thead.close();
                            El tbody = new El("tbody").open();
                            List<String> requiredParams = value.schema().required();
                            for (Map.Entry entry3 : value.schema().properties().entrySet()) {
                                String formName = (String)entry3.getKey();
                                SchemaObject schema = (SchemaObject)entry3.getValue();
                                El row = new El("tr").open();
                                this.render("td", formName);
                                String type = schema.type();
                                if (schema.format() != null) {
                                    type = type + " (" + schema.format() + ")";
                                }
                                this.render("td", type);
                                El paramDesc = new El("td").open();
                                if (schema.isDeprecated()) {
                                    this.render("strong", "DEPRECATED. ");
                                }
                                if (requiredParams != null && requiredParams.contains(formName)) {
                                    this.render("strong", "REQUIRED. ");
                                }
                                paramDesc.content(schema.description());
                                this.renderExamples(schema.example(), null, schema.defaultValue());
                                curlBody.append(" ").append(curlFormParam).append(" '").append(Mutils.urlEncode(formName)).append("=").append(HtmlDocumentor.bashValue(schema.example())).append("'");
                                paramDesc.close();
                                row.close();
                            }
                            tbody.close();
                            table.close();
                        }
                    }
                    String curlAccept = "";
                    if (!operation.responses().httpStatusCodes().isEmpty()) {
                        this.render("h4", "Responses");
                        El el = new El("table").open(Collections.singletonMap("class", "responseTable"));
                        El thead = new El("thead").open();
                        El theadRow = new El("tr").open();
                        this.render("th", "Code");
                        this.render("th", "Content Type");
                        this.render("th", "Description");
                        theadRow.close();
                        thead.close();
                        El tbody = new El("tbody").open();
                        for (Map.Entry<String, ResponseObject> respEntry : operation.responses().httpStatusCodes().entrySet()) {
                            El row = new El("tr").open();
                            String code = respEntry.getKey();
                            ResponseObject resp = respEntry.getValue();
                            this.render("td", code);
                            String contentTypes = resp.content() == null ? "" : String.join((CharSequence)"\n", resp.content().keySet());
                            this.render("td", contentTypes);
                            this.render("td", resp.description());
                            if (curlAccept.isEmpty() && !contentTypes.isEmpty()) {
                                curlAccept = " -H 'accept: " + contentTypes.split("\n", 2)[0] + "'";
                            }
                            row.close();
                        }
                        tbody.close();
                        el.close();
                    }
                    this.render("h4", "Curl");
                    String string = urlWithContext.replace("{", "(").replace("}", ")") + queryString;
                    this.render("code", "curl -is -X " + method.toUpperCase() + curlHeaders + curlAccept + curlBody + " '" + this.requestUri.resolve(string) + "'");
                    operationDiv.close();
                }
            }
            tagContainer.close();
        }
        body.close();
        html.close();
    }

    private static String bashValue(Object value) {
        return value == null || "".equals(value) ? "" : value.toString().replace("'", "'\\''");
    }

    private void renderExternalLinksParagraph(ExternalDocumentationObject externalDocs) throws IOException {
        if (externalDocs != null) {
            String url = externalDocs.url().toString();
            String desc = externalDocs.description() == null ? url : externalDocs.description();
            El ext = new El("p").open().content("For more info, see ");
            new El("a").open(Collections.singletonMap("href", url)).content(desc).close();
            ext.close();
        }
    }

    private void renderExamples(Object example, Map<String, ExampleObject> examples, Object defaultVal) throws IOException {
        Object div;
        if (example != null) {
            div = new El("div").open().content("Example: ");
            this.render("code", example.toString());
            ((El)div).close();
        } else if (examples != null) {
            for (Map.Entry<String, ExampleObject> exampleEntry : examples.entrySet()) {
                El div2 = new El("div").open();
                new El("code").open().content(exampleEntry.getKey()).close();
                ExampleObject ex = exampleEntry.getValue();
                new El("span").open().content(" ", ex.summary(), " ", ex.description()).close();
                new El("pre").open().content(ex.value()).close();
                div2.close();
            }
        }
        if (defaultVal != null) {
            div = new El("div").open().content("Default value: ");
            this.render("code", defaultVal.toString());
            ((El)div).close();
        }
    }

    private void renderIfValue(String tag, String value) throws IOException {
        if (value != null) {
            new El(tag).open().content(value).close();
        }
    }

    private void render(String tag, String value) throws IOException {
        new El(tag).open().content(value).close();
    }

    class El
    implements AutoCloseable {
        private final String tag;

        private El(String tag) {
            this.tag = tag;
        }

        El open() throws IOException {
            return this.open(null);
        }

        El open(Map<String, String> attributes) throws IOException {
            HtmlDocumentor.this.writer.write("<" + this.tag);
            if (attributes != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    HtmlDocumentor.this.writer.write(" " + Mutils.htmlEncode(entry.getKey()) + "=\"" + Mutils.htmlEncode(entry.getValue()) + "\"");
                }
            }
            HtmlDocumentor.this.writer.write(62);
            return this;
        }

        El contentRaw(String val) throws IOException {
            HtmlDocumentor.this.writer.write(val);
            return this;
        }

        El content(Object ... vals) throws IOException {
            if (vals != null) {
                for (Object val : vals) {
                    if (val == null) continue;
                    String stringVal = val.toString();
                    HtmlDocumentor.this.writer.write(Mutils.htmlEncode(stringVal).replace("\n", "<br>"));
                }
            }
            return this;
        }

        @Override
        public void close() throws IOException {
            HtmlDocumentor.this.writer.write("</" + this.tag + ">");
        }
    }
}

