/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.rest.JaxOutboundSseEvent;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.sse.OutboundSseEvent;

class JaxOutboundSseEventBuilder
implements OutboundSseEvent.Builder {
    private String id;
    private String name;
    private long milliseconds = -1L;
    private MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
    private String comment;
    private Class type;
    private Object data;
    private GenericType genericType;

    JaxOutboundSseEventBuilder() {
    }

    public OutboundSseEvent.Builder id(String id) {
        this.id = id;
        return this;
    }

    public OutboundSseEvent.Builder name(String name) {
        this.name = name;
        return this;
    }

    public OutboundSseEvent.Builder reconnectDelay(long milliseconds) {
        this.milliseconds = milliseconds >= 0L ? milliseconds : -1L;
        return this;
    }

    public OutboundSseEvent.Builder mediaType(MediaType mediaType) {
        if (mediaType == null) {
            throw new NullPointerException("mediaType");
        }
        this.mediaType = mediaType;
        return this;
    }

    public OutboundSseEvent.Builder comment(String comment) {
        this.comment = comment;
        return this;
    }

    public OutboundSseEvent.Builder data(Class type, Object data) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.type = type;
        this.data = data;
        return this;
    }

    public OutboundSseEvent.Builder data(GenericType type, Object data) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.genericType = type;
        this.data = data;
        return this;
    }

    public OutboundSseEvent.Builder data(Object data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = data;
        this.type = data.getClass();
        return this;
    }

    public OutboundSseEvent build() {
        if (this.data == null && this.comment == null) {
            throw new IllegalStateException("Either data or a comment must be set");
        }
        return new JaxOutboundSseEvent(this.id, this.name, this.milliseconds, this.mediaType, this.comment, this.type, this.data, this.genericType);
    }
}

