/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Cookie;
import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.rest.LowercasedMultivaluedHashMap;
import io.muserver.rest.MediaTypeDeterminer;
import io.muserver.rest.ReadOnlyMultivaluedMap;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class JaxRsHttpHeadersAdapter
implements HttpHeaders {
    private static final List<Locale> WILDCARD_LOCALES = Collections.singletonList(new Locale("*"));
    private static final List<MediaType> WILDCARD_MEDIA_TYPES = Collections.singletonList(MediaType.WILDCARD_TYPE);
    private final Headers muHeaders;
    private final List<Cookie> muCookies;
    private MultivaluedMap<String, String> copy;

    JaxRsHttpHeadersAdapter(Headers headers, List<Cookie> cookies) {
        this.muHeaders = headers;
        this.muCookies = cookies;
    }

    public List<String> getRequestHeader(String name) {
        return (List)this.getMutableRequestHeaders().get((Object)name);
    }

    public String getHeaderString(String name) {
        List<String> vals = this.getRequestHeader(name);
        if (vals == null) {
            return null;
        }
        return String.join((CharSequence)",", vals);
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return ReadOnlyMultivaluedMap.readOnly(this.getMutableRequestHeaders());
    }

    MultivaluedMap<String, String> getMutableRequestHeaders() {
        if (this.copy == null) {
            LowercasedMultivaluedHashMap c = new LowercasedMultivaluedHashMap();
            for (Map.Entry<String, String> entry : this.muHeaders) {
                c.add(entry.getKey(), entry.getValue());
            }
            this.copy = c;
        }
        return this.copy;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List<MediaType> mediaTypes = MediaTypeDeterminer.parseAcceptHeaders(this.muHeaders.getAll(HeaderNames.ACCEPT));
        if (mediaTypes.isEmpty()) {
            return WILDCARD_MEDIA_TYPES;
        }
        return mediaTypes.stream().sorted(MediaTypeDeterminer::compareQValues).collect(Collectors.toList());
    }

    public List<Locale> getAcceptableLanguages() {
        try {
            return this.getLocalesFromHeader(HeaderNames.ACCEPT_LANGUAGE, WILDCARD_LOCALES);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid accept-language header");
        }
    }

    private List<Locale> getLocalesFromHeader(CharSequence headerName, List<Locale> defaultLocales) {
        List<String> all = this.muHeaders.getAll(headerName);
        if (all.isEmpty()) {
            return defaultLocales;
        }
        return Locale.LanguageRange.parse(String.join((CharSequence)",", all)).stream().map(lr -> {
            String[] range = lr.getRange().split("-");
            switch (range.length) {
                case 3: {
                    return new Locale(range[0], range[1], range[2]);
                }
                case 2: {
                    return new Locale(range[0], range[1]);
                }
                case 1: {
                    return new Locale(range[0]);
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public MediaType getMediaType() {
        String type = this.muHeaders.get(HeaderNames.CONTENT_TYPE);
        return type == null ? null : MediaType.valueOf((String)type);
    }

    public Locale getLanguage() {
        List<Locale> localesFromHeader = this.getLocalesFromHeader(HeaderNames.CONTENT_LANGUAGE, null);
        return localesFromHeader == null || localesFromHeader.isEmpty() ? null : localesFromHeader.get(0);
    }

    public Map<String, jakarta.ws.rs.core.Cookie> getCookies() {
        HashMap<String, jakarta.ws.rs.core.Cookie> all = new HashMap<String, jakarta.ws.rs.core.Cookie>();
        for (Cookie cookie : this.muCookies) {
            all.put(cookie.name(), new jakarta.ws.rs.core.Cookie(cookie.name(), cookie.value()));
        }
        return all;
    }

    public Date getDate() {
        long timeMillis = this.muHeaders.getTimeMillis(HeaderNames.DATE, -1L);
        return timeMillis < 0L ? null : new Date(timeMillis);
    }

    public int getLength() {
        return this.muHeaders.getInt(HeaderNames.CONTENT_LENGTH, -1);
    }
}

