/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.AsyncSsePublisher;
import io.muserver.MuResponse;
import io.muserver.ResponseCompleteListener;
import io.muserver.rest.EntityProviders;
import io.muserver.rest.JaxRSResponse;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JaxSseEventSinkImpl
implements SseEventSink {
    private static final Logger log = LoggerFactory.getLogger(JaxSseEventSinkImpl.class);
    private final AsyncSsePublisher ssePublisher;
    private final MuResponse response;
    private final EntityProviders entityProviders;

    public JaxSseEventSinkImpl(AsyncSsePublisher ssePublisher, MuResponse response, EntityProviders entityProviders) {
        this.ssePublisher = ssePublisher;
        this.response = response;
        this.entityProviders = entityProviders;
    }

    void setResponseCompleteHandler(ResponseCompleteListener listener) {
        this.ssePublisher.setResponseCompleteHandler(listener);
    }

    public boolean isClosed() {
        return this.ssePublisher.isClosed();
    }

    public CompletionStage<?> send(OutboundSseEvent event) {
        CompletionStage<?> stage = null;
        try {
            if (event.isReconnectDelaySet()) {
                stage = this.ssePublisher.setClientReconnectTime(event.getReconnectDelay(), TimeUnit.MILLISECONDS);
            }
            if (event.getComment() != null) {
                stage = this.ssePublisher.sendComment(event.getComment());
            }
            if (event.getData() != null) {
                MessageBodyWriter<?> messageBodyWriter = this.entityProviders.selectWriter(event.getType(), event.getGenericType(), JaxRSResponse.Builder.EMPTY_ANNOTATIONS, event.getMediaType());
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    messageBodyWriter.writeTo(event.getData(), event.getType(), event.getGenericType(), JaxRSResponse.Builder.EMPTY_ANNOTATIONS, event.getMediaType(), JaxRSResponse.muHeadersToJaxObj(this.response.headers()), (OutputStream)out);
                    String data = new String(out.toByteArray(), StandardCharsets.UTF_8);
                    stage = this.ssePublisher.send(data, event.getName(), event.getId());
                }
            }
            if (stage == null) {
                throw new IllegalArgumentException("The event had nothing to send");
            }
        }
        catch (Throwable e) {
            if (e instanceof ServerErrorException) {
                log.warn("Server error while writing data to SSE stream", e);
            }
            CompletableFuture f = new CompletableFuture();
            f.completeExceptionally(e);
            stage = f;
        }
        return stage;
    }

    public void close() {
        this.ssePublisher.close();
    }
}

