/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.rest.CombinedMediaType;
import io.muserver.rest.MediaTypeHeaderDelegate;
import io.muserver.rest.ObjWithType;
import io.muserver.rest.ProviderWrapper;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class MediaTypeDeterminer {
    MediaTypeDeterminer() {
    }

    public static MediaType determine(ObjWithType responseObject, List<MediaType> classProduces, List<MediaType> methodProduces, List<ProviderWrapper<MessageBodyWriter<?>>> messageBodyWriters, List<MediaType> clientAccepts, Annotation[] annotations) {
        HashSet<MediaType> a;
        MediaType rmt;
        if (responseObject.response != null && (rmt = responseObject.response.getMediaType()) != null) {
            return rmt;
        }
        Set<Object> p = !methodProduces.isEmpty() ? new HashSet<MediaType>(methodProduces) : (!classProduces.isEmpty() ? new HashSet<MediaType>(classProduces) : messageBodyWriters.stream().filter(writer -> ((MessageBodyWriter)writer.provider).isWriteable(responseObject.type, responseObject.genericType, annotations, MediaType.WILDCARD_TYPE)).flatMap(writer -> writer.mediaTypes.stream()).collect(Collectors.toSet()));
        if (p.isEmpty()) {
            p.add(MediaType.WILDCARD_TYPE);
        }
        if ((a = new HashSet<MediaType>(clientAccepts)).isEmpty()) {
            a.add(MediaType.WILDCARD_TYPE);
        }
        ArrayList<CombinedMediaType> m = new ArrayList<CombinedMediaType>();
        for (MediaType mediaTypeA : a) {
            for (MediaType mediaType : p) {
                if (!mediaTypeA.isCompatible(mediaType)) continue;
                m.add(CombinedMediaType.s(mediaTypeA, mediaType));
            }
        }
        if (m.isEmpty()) {
            throw new NotAcceptableException("Could not convert to a type acceptable to the client");
        }
        m.sort(Comparator.reverseOrder());
        for (CombinedMediaType mediaType : m) {
            if (!mediaType.isConcrete()) continue;
            return new MediaType(mediaType.type, mediaType.subType, mediaType.charset);
        }
        for (CombinedMediaType mediaType : m) {
            if (!mediaType.isWildcardType && !mediaType.type.equals("application") || !mediaType.isWildcardSubtype) continue;
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        throw new NotAcceptableException("Could not determine the mime type for the response. Try setting an @Produces annotation on the method.");
    }

    static List<MediaType> supportedProducesTypes(GenericDeclaration annotationSource) {
        Produces methodProducesAnnotation = annotationSource.getAnnotation(Produces.class);
        return methodProducesAnnotation != null ? MediaTypeHeaderDelegate.fromStrings(Arrays.asList(methodProducesAnnotation.value())) : Collections.emptyList();
    }

    static List<MediaType> supportedConsumesTypes(GenericDeclaration consumableMediaTypes) {
        Consumes methodConsumesAnnotation = consumableMediaTypes.getAnnotation(Consumes.class);
        return methodConsumesAnnotation != null ? MediaTypeHeaderDelegate.fromStrings(Arrays.asList(methodConsumesAnnotation.value())) : Collections.emptyList();
    }

    static List<MediaType> parseAcceptHeaders(List<String> headers) throws IllegalArgumentException {
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        for (String header : headers) {
            String[] bits;
            for (String bit : bits = header.split(",")) {
                if (bit.isEmpty()) continue;
                list.add(MediaType.valueOf((String)bit));
            }
        }
        return list;
    }

    static int compareQValues(MediaType one, MediaType two) {
        double q1 = Double.parseDouble(one.getParameters().getOrDefault("q", "1.0"));
        double q2 = Double.parseDouble(two.getParameters().getOrDefault("q", "1.0"));
        int qCompare = Double.compare(q2, q1);
        if (qCompare == 0 && (qCompare = Boolean.compare(one.isWildcardType(), two.isWildcardType())) == 0 && (qCompare = Boolean.compare(one.isWildcardSubtype(), two.isWildcardSubtype())) == 0) {
            qCompare = Integer.compare(two.getParameters().size(), one.getParameters().size());
        }
        return qCompare;
    }
}

