/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.MediaTypeParser;
import io.muserver.rest.MuRuntimeDelegate;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class MediaTypeHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<MediaType> {
    static final MediaType NONE;

    MediaTypeHeaderDelegate() {
    }

    public MediaType fromString(String value) {
        return MediaTypeParser.fromString(value);
    }

    public String toString(MediaType mediaType) {
        return MediaTypeParser.toString(mediaType);
    }

    static List<MediaType> fromStrings(List<String> accepts) {
        if (accepts == null || accepts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MediaType> results = new ArrayList<MediaType>();
        for (String acceptMess : accepts) {
            for (String accept : acceptMess.split(",")) {
                results.add(MediaType.valueOf((String)accept.trim()));
            }
        }
        return results;
    }

    static boolean atLeastOneCompatible(List<MediaType> providerProduces, List<MediaType> consumerAccepts, String checkParameter) {
        for (MediaType clientAccept : consumerAccepts) {
            for (MediaType produce : providerProduces) {
                String clientParam;
                boolean compatible = produce.isCompatible(clientAccept);
                if (!compatible) continue;
                if (checkParameter != null && (clientParam = (String)clientAccept.getParameters().get(checkParameter)) != null) {
                    String serverParam = (String)produce.getParameters().get(checkParameter);
                    compatible = clientParam.equalsIgnoreCase(serverParam);
                }
                if (!compatible) continue;
                return true;
            }
        }
        return false;
    }

    static {
        MuRuntimeDelegate.ensureSet();
        NONE = new MediaType("-", "-");
    }
}

