/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Mutils;
import io.muserver.rest.Jaxutils;
import io.muserver.rest.MuPathSegment;
import io.muserver.rest.MuRuntimeDelegate;
import io.muserver.rest.MuUriInfo;
import io.muserver.rest.UriPattern;
import io.netty.handler.codec.http.QueryStringDecoder;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MuUriBuilder
extends UriBuilder {
    private String scheme;
    private String userInfo;
    private String host;
    private int port = -1;
    private List<MuPathSegment> pathSegments = new ArrayList<MuPathSegment>();
    private MultivaluedMap<String, String> query = new MultivaluedHashMap();
    private String fragment;
    private boolean hasPrecedingSlash = false;
    private boolean hasTrailingSlash = false;

    MuUriBuilder() {
    }

    private MuUriBuilder(String scheme, String userInfo, String host, int port, List<MuPathSegment> pathSegments, boolean hasPrecedingSlash, boolean hasTrailingSlash, MultivaluedMap<String, String> query, String fragment) {
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.pathSegments = new ArrayList<MuPathSegment>(pathSegments);
        this.hasTrailingSlash = hasTrailingSlash;
        this.hasPrecedingSlash = hasPrecedingSlash;
        MultivaluedHashMap copy = new MultivaluedHashMap();
        copy.putAll(query);
        this.query = copy;
        this.fragment = fragment;
    }

    public UriBuilder clone() {
        return new MuUriBuilder(this.scheme, this.userInfo, this.host, this.port, this.pathSegments, this.hasPrecedingSlash, this.hasTrailingSlash, this.query, this.fragment);
    }

    public UriBuilder uri(URI uri) {
        this.scheme(uri.getScheme());
        this.userInfo(uri.getUserInfo());
        this.host(uri.getHost());
        this.port(uri.getPort());
        this.replacePath(uri.getRawPath());
        this.replaceQuery(uri.getRawQuery());
        this.fragment(uri.getRawFragment());
        return this;
    }

    public UriBuilder uri(String uriTemplate) {
        if (uriTemplate == null) {
            throw new IllegalArgumentException("uriTemplate is null");
        }
        Pattern parts = Pattern.compile("(?<firstBit>[^/]*//[^/]*)?(?<path>[^?#]*)(?<end>.*)");
        Matcher matcher = parts.matcher(uriTemplate);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(uriTemplate + " is not a valid URI");
        }
        String path = matcher.group("path");
        UriBuilder builder = this.uri(URI.create(matcher.group("firstBit") + matcher.group("end")));
        builder.replacePath(path);
        return builder;
    }

    public UriBuilder schemeSpecificPart(String ssp) {
        MuUriBuilder builder = (MuUriBuilder)MuUriBuilder.fromUri((URI)URI.create(this.scheme + "://" + ssp));
        this.scheme = builder.scheme;
        this.userInfo = builder.userInfo;
        this.host = builder.host;
        this.port = builder.port;
        this.pathSegments = builder.pathSegments;
        this.setSlashes(ssp);
        return this;
    }

    public UriBuilder scheme(String scheme) {
        this.scheme = MuUriBuilder.decode(scheme);
        return this;
    }

    public UriBuilder userInfo(String userInfo) {
        this.userInfo = MuUriBuilder.decode(userInfo);
        return this;
    }

    public UriBuilder host(String host) {
        this.host = MuUriBuilder.decode(host);
        return this;
    }

    public UriBuilder port(int port) {
        this.port = port;
        return this;
    }

    public UriBuilder path(String path) {
        Mutils.notNull("path", path);
        this.setSlashes(path);
        this.pathSegments.addAll(MuUriInfo.pathStringToSegments(MuUriBuilder.decode(path), false).collect(Collectors.toList()));
        return this;
    }

    public UriBuilder replacePath(String path) {
        this.pathSegments.clear();
        return this.path(path);
    }

    public UriBuilder path(Class resource) {
        Mutils.notNull("resource", resource);
        return this.path(this.findResourcePath(resource));
    }

    private String findResourcePath(Class resource) {
        Path pathAn = resource.getDeclaredAnnotation(Path.class);
        if (pathAn == null) {
            throw new IllegalArgumentException(resource + " is not a JAX-RS class");
        }
        return pathAn.value();
    }

    public UriBuilder path(Class resource, String method) {
        Method selected = null;
        for (Method m : resource.getDeclaredMethods()) {
            if (!m.getName().equals(method)) continue;
            if (selected == null) {
                selected = m;
                continue;
            }
            throw new IllegalArgumentException("There is more than one method named " + method + " in " + resource);
        }
        if (selected != null) {
            return this.path(selected);
        }
        throw new IllegalArgumentException("Could not find " + resource + "#" + method);
    }

    public UriBuilder path(Method method) {
        this.path(method.getDeclaringClass());
        Path methodPath = method.getDeclaredAnnotation(Path.class);
        if (methodPath != null) {
            this.path(methodPath.value());
        }
        return this;
    }

    public UriBuilder segment(String ... segments) {
        Mutils.notNull("segments", segments);
        for (String segment : segments) {
            Mutils.notNull("segment", segment);
            this.pathSegments.addAll(MuUriInfo.pathStringToSegments(MuUriBuilder.decode(segment), true).collect(Collectors.toList()));
        }
        this.hasTrailingSlash = false;
        return this;
    }

    public UriBuilder replaceMatrix(String matrix) {
        MultivaluedMap<String, String> params = this.getOrCreateCurrentSegment().getMatrixParameters();
        params.clear();
        if (matrix != null) {
            String[] parts;
            for (String part : parts = matrix.split(";")) {
                String[] nameValue = part.split("=");
                if (nameValue.length != 2) {
                    throw new IllegalArgumentException("Not a valid matrix string: " + matrix);
                }
                this.matrixParam(nameValue[0], nameValue[1]);
            }
        }
        return this;
    }

    public UriBuilder matrixParam(String name, Object ... values) {
        Mutils.notNull("name", name);
        Mutils.notNull("values", values);
        MultivaluedMap<String, String> params = this.getOrCreateCurrentSegment().getMatrixParameters();
        for (Object value : values) {
            params.add((Object)name, (Object)MuUriBuilder.decode(value));
        }
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) {
        Mutils.notNull("name", name);
        Mutils.notNull("values", values);
        MultivaluedMap<String, String> params = this.getOrCreateCurrentSegment().getMatrixParameters();
        params.replace((Object)name, Stream.of(values).map(Object::toString).collect(Collectors.toList()));
        return this;
    }

    private MuPathSegment getOrCreateCurrentSegment() {
        MuPathSegment ps;
        if (this.pathSegments.isEmpty()) {
            ps = new MuPathSegment("", (MultivaluedMap<String, String>)new MultivaluedHashMap());
            this.pathSegments.add(ps);
        } else {
            ps = this.pathSegments.get(this.pathSegments.size() - 1);
        }
        return ps;
    }

    public UriBuilder replaceQuery(String qs) {
        if (qs == null) {
            this.query.clear();
        } else {
            this.query = new MultivaluedHashMap();
            QueryStringDecoder decoder = new QueryStringDecoder(qs, false);
            for (Map.Entry entry : decoder.parameters().entrySet()) {
                List values = (List)entry.getValue();
                this.queryParam((String)entry.getKey(), values.toArray(new Object[values.size()]));
            }
        }
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) {
        Mutils.notNull("name", name);
        Mutils.notNull("values", values);
        name = MuUriBuilder.decode(name);
        for (Object value : values) {
            this.query.add((Object)name, (Object)MuUriBuilder.decode(value.toString()));
        }
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) {
        Mutils.notNull("name", name);
        this.query.remove((Object)name);
        return values == null ? this : this.queryParam(name, values);
    }

    public UriBuilder fragment(String fragment) {
        this.fragment = MuUriBuilder.decode(fragment);
        return this;
    }

    public UriBuilder resolveTemplate(String name, Object value) {
        Mutils.notNull("name", name);
        Mutils.notNull("value", value);
        return this.resolveTemplate(name, value, true);
    }

    public UriBuilder resolveTemplateFromEncoded(String name, Object value) {
        Mutils.notNull("name", name);
        Mutils.notNull("value", value);
        String decoded = Jaxutils.leniantUrlDecode(value.toString());
        return this.resolveTemplate(name, decoded, true);
    }

    public UriBuilder resolveTemplates(Map<String, Object> templateValues) {
        Mutils.notNull("templateValues", templateValues);
        return this.resolveTemplates(templateValues, true);
    }

    public UriBuilder resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws IllegalArgumentException {
        Mutils.notNull("templateValues", templateValues);
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            this.resolveTemplate(entry.getKey(), entry.getValue(), encodeSlashInPath);
        }
        return this;
    }

    public UriBuilder resolveTemplatesFromEncoded(Map<String, Object> templateValues) {
        Mutils.notNull("templateValues", templateValues);
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            this.resolveTemplateFromEncoded(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public UriBuilder resolveTemplate(String name, Object value, boolean encodeSlashInPath) {
        Mutils.notNull("name", name);
        Mutils.notNull("value", value);
        String val = value.toString();
        this.scheme = MuUriBuilder.resolve(this.scheme, name, val);
        this.userInfo = MuUriBuilder.resolve(this.userInfo, name, val);
        this.host = MuUriBuilder.resolve(this.host, name, val);
        this.pathSegments = this.pathSegments.stream().flatMap(ps -> ps.resolve(name, val, encodeSlashInPath).stream()).collect(Collectors.toList());
        if (!this.query.isEmpty()) {
            MultivaluedHashMap nq = new MultivaluedHashMap();
            for (Map.Entry entry : this.query.entrySet()) {
                String key = MuUriBuilder.resolve((String)entry.getKey(), name, val);
                nq.addAll((Object)key, ((List)entry.getValue()).stream().map(s -> MuUriBuilder.resolve(s, name, val)).collect(Collectors.toList()));
            }
            this.query = nq;
        }
        this.fragment = MuUriBuilder.resolve(this.fragment, name, val);
        return this;
    }

    public URI buildFromMap(Map<String, ?> values) {
        return this.buildFromMap(values, true);
    }

    public URI buildFromMap(Map<String, ?> values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        MuUriBuilder resolved = this.cloneAndResolve(values, encodeSlashInPath, false);
        return URI.create(resolved.buildIt(Mutils::urlEncode));
    }

    public URI buildFromEncodedMap(Map<String, ?> values) throws IllegalArgumentException, UriBuilderException {
        MuUriBuilder resolved = this.cloneAndResolve(values, true, true);
        return URI.create(resolved.buildIt(Mutils::urlEncode));
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.build(values, true);
    }

    public URI build(Object[] values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        Map<String, ?> valueMap = this.valuesToMap(values);
        return this.buildFromMap(valueMap, encodeSlashInPath);
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        Map<String, ?> valueMap = this.valuesToMap(values);
        return this.buildFromEncodedMap(valueMap);
    }

    public String toTemplate() {
        return this.buildIt(s -> s);
    }

    private MuUriBuilder cloneAndResolve(Map<String, ?> values, boolean encodeSlashInPath, boolean valuesAlreadyEncoded) {
        if (values.isEmpty()) {
            return this;
        }
        MuUriBuilder copy = (MuUriBuilder)this.clone();
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            Object value = entry.getValue();
            if (valuesAlreadyEncoded) {
                value = Jaxutils.leniantUrlDecode(value.toString());
            }
            copy.resolveTemplate(entry.getKey(), value, encodeSlashInPath);
        }
        return copy;
    }

    static String resolve(String template, String name, String value) {
        if (template == null) {
            return null;
        }
        return template.replaceAll("\\{\\s*" + Pattern.quote(name) + "\\s*(:[^}]*)?\\s*}", value);
    }

    private String buildIt(Function<String, String> encodeFunction) {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(encodeFunction.apply(this.scheme)).append("://");
        }
        if (this.userInfo != null) {
            String encodedUserInfo = encodeFunction.apply(this.userInfo);
            encodedUserInfo = encodedUserInfo.replaceFirst("%3A", ":");
            sb.append(encodedUserInfo).append('@');
        }
        if (this.host != null) {
            sb.append(encodeFunction.apply(this.host));
        }
        if (this.port != -1) {
            sb.append(':').append(this.port);
        }
        if (!this.pathSegments.isEmpty()) {
            if (this.hasPrecedingSlash || sb.length() > 0) {
                sb.append('/');
            }
            sb.append(this.pathSegments.stream().map(muPathSegment -> muPathSegment.toString(encodeFunction)).collect(Collectors.joining("/")));
        }
        if (this.hasTrailingSlash) {
            sb.append('/');
        }
        if (!this.query.isEmpty()) {
            sb.append('?');
            boolean isFirst = true;
            for (Map.Entry entry : this.query.entrySet()) {
                String key = encodeFunction.apply((String)entry.getKey());
                for (String val : (List)entry.getValue()) {
                    if (!isFirst) {
                        sb.append('&');
                    }
                    sb.append(key).append('=').append(encodeFunction.apply(val));
                    isFirst = false;
                }
            }
        }
        if (this.fragment != null) {
            sb.append('#').append(encodeFunction.apply(this.fragment));
        }
        return sb.toString();
    }

    private Map<String, ?> valuesToMap(Object[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptyMap();
        }
        ArrayList<String> sorted = new ArrayList<String>();
        MuUriBuilder.addTemplateNames(sorted, this.scheme);
        MuUriBuilder.addTemplateNames(sorted, this.userInfo);
        MuUriBuilder.addTemplateNames(sorted, this.host);
        for (MuPathSegment pathSegment : this.pathSegments) {
            for (String pspp : pathSegment.pathParameters()) {
                if (sorted.contains(pspp)) continue;
                sorted.add(pspp);
            }
        }
        for (Map.Entry entry : this.query.entrySet()) {
            MuUriBuilder.addTemplateNames(sorted, (String)entry.getKey());
            for (String val : (List)entry.getValue()) {
                MuUriBuilder.addTemplateNames(sorted, val);
            }
        }
        MuUriBuilder.addTemplateNames(sorted, this.fragment);
        if (sorted.size() != values.length) {
            throw new IllegalArgumentException("There are " + sorted.size() + " parameters (" + sorted + ") but " + values.length + " values " + Arrays.toString(values) + " were supplied.");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int index = 0;
        for (String name : sorted) {
            Object value = values[index];
            if (value == null) {
                throw new IllegalArgumentException("Value at index " + index + " was null");
            }
            map.put(name, value);
            ++index;
        }
        return map;
    }

    private static void addTemplateNames(List<String> sorted, String value) {
        if (value != null) {
            List<String> toAdd = UriPattern.uriTemplateToRegex(value).namedGroups();
            for (String s : toAdd) {
                if (sorted.contains(s)) continue;
                sorted.add(s);
            }
        }
    }

    private static String decode(Object value) {
        return value == null ? null : Jaxutils.leniantUrlDecode(value.toString());
    }

    private void setSlashes(String path) {
        if (this.pathSegments.isEmpty()) {
            this.hasPrecedingSlash = path.startsWith("/");
        }
        this.hasTrailingSlash = path.endsWith("/");
    }

    static {
        MuRuntimeDelegate.ensureSet();
    }
}

