/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.ParameterizedHeaderWithValue;
import io.muserver.rest.CombinedMediaType;
import io.muserver.rest.MediaTypeHeaderDelegate;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

class MuVariantListBuilder
extends Variant.VariantListBuilder {
    private final List<Locale> languages = new ArrayList<Locale>();
    private final List<String> encodings = new ArrayList<String>();
    private final List<MediaType> mediaTypes = new ArrayList<MediaType>();
    private final List<Variant> variants = new ArrayList<Variant>();

    MuVariantListBuilder() {
    }

    public List<Variant> build() {
        if (this.addPending()) {
            this.add();
        }
        ArrayList<Variant> temp = new ArrayList<Variant>(this.variants);
        this.variants.clear();
        return temp;
    }

    private boolean addPending() {
        return !this.languages.isEmpty() || !this.encodings.isEmpty() || !this.mediaTypes.isEmpty();
    }

    public Variant.VariantListBuilder add() {
        if (!this.addPending()) {
            throw new IllegalStateException("No variants to add");
        }
        List<Object> mts = this.mediaTypes.isEmpty() ? Collections.singletonList(null) : this.mediaTypes;
        List<Object> langs = this.languages.isEmpty() ? Collections.singletonList(null) : this.languages;
        List<Object> encs = this.encodings.isEmpty() ? Collections.singletonList(null) : this.encodings;
        for (String string : encs) {
            for (Locale locale : langs) {
                for (MediaType mediaType : mts) {
                    this.variants.add(new Variant(mediaType, locale, string));
                }
            }
        }
        this.mediaTypes.clear();
        this.languages.clear();
        this.encodings.clear();
        return this;
    }

    public Variant.VariantListBuilder languages(Locale ... languages) {
        this.languages.addAll(Arrays.asList(languages));
        return this;
    }

    public Variant.VariantListBuilder encodings(String ... encodings) {
        this.encodings.addAll(Arrays.asList(encodings));
        return this;
    }

    public Variant.VariantListBuilder mediaTypes(MediaType ... mediaTypes) {
        this.mediaTypes.addAll(Arrays.asList(mediaTypes));
        return this;
    }

    static Variant selectVariant(List<Variant> available, List<Locale.LanguageRange> preferredLanguages, List<MediaType> acceptableMediaTypes, List<ParameterizedHeaderWithValue> acceptableEncodings) {
        Locale.LanguageRange wildcardRanger = new Locale.LanguageRange("*");
        ArrayList<Variant> candidates = new ArrayList<Variant>();
        for (Variant candidate : available) {
            MediaType cmt = candidate.getMediaType();
            boolean mtOkay = cmt == null || MediaTypeHeaderDelegate.atLeastOneCompatible(Collections.singletonList(cmt), acceptableMediaTypes, "charset");
            String cenc = candidate.getEncoding();
            boolean encOkay = cenc == null || acceptableEncodings.stream().anyMatch(ae -> ae.value().equals(cenc));
            Locale clang = candidate.getLanguage();
            boolean langOk = clang == null || Locale.lookup(preferredLanguages, Collections.singleton(clang)) != null || preferredLanguages.contains(wildcardRanger);
            if (!langOk || !encOkay || !mtOkay) continue;
            candidates.add(candidate);
        }
        return candidates.stream().min((v1, v2) -> {
            int langCompare = Boolean.compare(v2.getLanguage() == null, v1.getLanguage() == null);
            if (langCompare == 0 && v1.getLanguage() != null) {
                Locale bestLang = Locale.lookup(preferredLanguages, Arrays.asList(v1.getLanguage(), v2.getLanguage()));
                langCompare = Boolean.compare(Objects.equals(bestLang, v2.getLanguage()), Objects.equals(bestLang, v1.getLanguage()));
            }
            if (langCompare != 0) {
                return langCompare;
            }
            int mtCompare = Boolean.compare(v2.getMediaType() != null, v1.getMediaType() != null);
            if (mtCompare == 0 && v1.getMediaType() != null) {
                MediaType bestMT = MuVariantListBuilder.bestMediaType(acceptableMediaTypes, Arrays.asList(v1.getMediaType(), v2.getMediaType()));
                mtCompare = Boolean.compare(Objects.equals(bestMT, v2.getMediaType()), Objects.equals(bestMT, v1.getMediaType()));
            }
            if (mtCompare != 0) {
                return mtCompare;
            }
            int encCompare = Boolean.compare(v2.getEncoding() != null, v1.getEncoding() != null);
            if (encCompare == 0 && v1.getEncoding() != null) {
                encCompare = Double.compare(MuVariantListBuilder.bestEncodingScore(acceptableEncodings, v2), MuVariantListBuilder.bestEncodingScore(acceptableEncodings, v1));
            }
            return encCompare;
        }).orElse(null);
    }

    private static MediaType bestMediaType(List<MediaType> acceptableMediaTypes, Collection<MediaType> candidates) {
        HashMap<CombinedMediaType, MediaType> combinedToServerType = new HashMap<CombinedMediaType, MediaType>();
        ArrayList<CombinedMediaType> m = new ArrayList<CombinedMediaType>();
        for (MediaType clientAccepts : acceptableMediaTypes) {
            for (MediaType serverProduces : candidates) {
                if (!clientAccepts.isCompatible(serverProduces)) continue;
                CombinedMediaType combined = CombinedMediaType.s(clientAccepts, serverProduces);
                combinedToServerType.put(combined, serverProduces);
                m.add(combined);
            }
        }
        if (m.isEmpty()) {
            return null;
        }
        m.sort(Comparator.reverseOrder());
        return (MediaType)combinedToServerType.get(m.get(0));
    }

    private static double bestEncodingScore(List<ParameterizedHeaderWithValue> acceptableEncodings, Variant variant) {
        return acceptableEncodings.stream().filter(enc -> variant.getEncoding().equals(enc.value())).min((o1, o2) -> Double.compare(MuVariantListBuilder.qScore(o2), MuVariantListBuilder.qScore(o1))).map(MuVariantListBuilder::qScore).orElse(1.0);
    }

    private static double qScore(ParameterizedHeaderWithValue p) {
        return Double.parseDouble(p.parameter("q", "1.0"));
    }
}

