/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import jakarta.ws.rs.core.PathSegment;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathMatch {
    public static final PathMatch EMPTY_MATCH = new PathMatch(true, Collections.emptyMap(), Pattern.compile("").matcher(""));
    private final boolean matches;
    private final Map<String, PathSegment> params;
    private final Matcher matcher;

    PathMatch(boolean matches, Map<String, PathSegment> params, Matcher matcher) {
        this.matches = matches;
        this.params = params;
        this.matcher = matcher;
    }

    public boolean prefixMatches() {
        return this.matches;
    }

    public boolean fullyMatches() {
        return this.matches && this.lastGroup() == null;
    }

    public Map<String, String> params() {
        HashMap<String, String> copy = new HashMap<String, String>(this.params.size());
        for (Map.Entry<String, PathSegment> entry : this.params.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().getPath());
        }
        return copy;
    }

    public Map<String, PathSegment> segments() {
        return this.params;
    }

    public Matcher regexMatcher() {
        return this.matcher;
    }

    String lastGroup() {
        String group = this.matcher.group(this.matcher.groupCount());
        return "/".equals(group) ? null : group;
    }

    public String toString() {
        return "PathMatch{matches=" + this.matches + ", params=" + this.params + '}';
    }
}

