/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Method;
import io.muserver.Mutils;
import io.muserver.openapi.HeaderObjectBuilder;
import io.muserver.openapi.MediaTypeObject;
import io.muserver.openapi.MediaTypeObjectBuilder;
import io.muserver.openapi.OperationObjectBuilder;
import io.muserver.openapi.RequestBodyObject;
import io.muserver.openapi.RequestBodyObjectBuilder;
import io.muserver.openapi.ResponseObject;
import io.muserver.openapi.ResponseObjectBuilder;
import io.muserver.openapi.ResponsesObjectBuilder;
import io.muserver.openapi.SchemaObject;
import io.muserver.openapi.SchemaObjectBuilder;
import io.muserver.rest.ApiResponse;
import io.muserver.rest.ApiResponseObj;
import io.muserver.rest.ApiResponses;
import io.muserver.rest.DescriptionData;
import io.muserver.rest.MediaTypeHeaderDelegate;
import io.muserver.rest.RequestMatcher;
import io.muserver.rest.ResourceClass;
import io.muserver.rest.ResourceMethodParam;
import io.muserver.rest.ResponseHeader;
import io.muserver.rest.SchemaObjectCustomizer;
import io.muserver.rest.SchemaObjectCustomizerContext;
import io.muserver.rest.SchemaObjectCustomizerTarget;
import io.muserver.rest.SchemaReference;
import io.muserver.rest.UriPattern;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.core.MediaType;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ResourceMethod {
    final ResourceClass resourceClass;
    final UriPattern pathPattern;
    final java.lang.reflect.Method methodHandle;
    final Method httpMethod;
    final String pathTemplate;
    final List<MediaType> effectiveConsumes;
    final List<MediaType> directlyConsumes;
    final List<MediaType> directlyProduces;
    final List<MediaType> effectiveProduces;
    final List<ResourceMethodParam> params;
    private final SchemaObjectCustomizer schemaObjectCustomizer;
    private final DescriptionData descriptionData;
    private final boolean isDeprecated;
    private final List<Class<? extends Annotation>> nameBindingAnnotations;
    final Annotation[] methodAnnotations;

    ResourceMethod(ResourceClass resourceClass, UriPattern pathPattern, java.lang.reflect.Method methodHandle, List<ResourceMethodParam> params, Method httpMethod, String pathTemplate, List<MediaType> produces, List<MediaType> consumes, SchemaObjectCustomizer schemaObjectCustomizer, DescriptionData descriptionData, boolean isDeprecated, List<Class<? extends Annotation>> nameBindingAnnotations, Annotation[] methodAnnotations) {
        this.resourceClass = resourceClass;
        this.pathPattern = pathPattern;
        this.methodHandle = methodHandle;
        this.params = params;
        this.httpMethod = httpMethod;
        this.pathTemplate = pathTemplate;
        this.directlyProduces = produces;
        this.directlyConsumes = consumes;
        this.schemaObjectCustomizer = schemaObjectCustomizer;
        this.descriptionData = descriptionData;
        this.isDeprecated = isDeprecated;
        this.nameBindingAnnotations = nameBindingAnnotations;
        this.methodAnnotations = methodAnnotations;
        List<MediaType> list = !produces.isEmpty() ? produces : (this.effectiveProduces = !resourceClass.produces.isEmpty() ? resourceClass.produces : RequestMatcher.WILDCARD_AS_LIST);
        this.effectiveConsumes = !consumes.isEmpty() ? consumes : (!resourceClass.consumes.isEmpty() ? resourceClass.consumes : RequestMatcher.WILDCARD_AS_LIST);
    }

    boolean hasAll(List<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (this.nameBindingAnnotations.contains(annotation) || this.resourceClass.nameBindingAnnotations.contains(annotation)) continue;
            return false;
        }
        return true;
    }

    List<ResourceMethodParam> paramsIncludingLocators() {
        if (this.resourceClass.locatorMethod == null) {
            return this.params;
        }
        ArrayList<ResourceMethodParam> all = new ArrayList<ResourceMethodParam>(this.resourceClass.locatorMethod.paramsIncludingLocators());
        all.addAll(this.params);
        return all;
    }

    boolean isSubResource() {
        return this.pathPattern != null;
    }

    boolean isSubResourceLocator() {
        return this.httpMethod == null;
    }

    Object invoke(Object ... params) throws Exception {
        try {
            return this.methodHandle.invoke(this.resourceClass.resourceInstance, params);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    OperationObjectBuilder createOperationBuilder(List<SchemaReference> customSchemas) {
        List<ApiResponseObj> apiResponseList = ResourceMethod.getApiResponses(this.methodHandle);
        HashMap<String, ResponseObject> httpStatusCodes = new HashMap<String, ResponseObject>();
        for (ApiResponseObj apiResponse : apiResponseList) {
            Class<?> responseClass = apiResponse.response;
            Stream<MediaType> responseTypesStream = apiResponse.contentType.length != 0 ? Stream.of(apiResponse.contentType).map(MediaType::valueOf) : ("204".equals(apiResponse.code) ? null : this.effectiveProduces.stream());
            Map<String, MediaTypeObject> content = responseTypesStream == null ? null : responseTypesStream.collect(Collectors.toMap(MediaType::toString, mt -> {
                SchemaObject responseSchema;
                Object example;
                Object object = example = Mutils.nullOrEmpty(apiResponse.example) ? null : apiResponse.example;
                if (Void.TYPE.isAssignableFrom(responseClass)) {
                    responseSchema = null;
                } else {
                    SchemaReference schemaReference = SchemaReference.find(customSchemas, responseClass, apiResponse.genericReturnType);
                    SchemaObjectBuilder builder = schemaReference == null ? SchemaObjectBuilder.schemaObjectFrom(responseClass) : schemaReference.schema.toBuilder();
                    responseSchema = this.schemaObjectCustomizer.customize(builder, this.schemaContext(SchemaObjectCustomizerTarget.RESPONSE_BODY, null, responseClass, apiResponse.genericReturnType, (MediaType)mt)).build();
                    if (responseSchema.example() != null) {
                        example = responseSchema.example();
                    }
                }
                return MediaTypeObjectBuilder.mediaTypeObject().withSchema(responseSchema).withExample(example).build();
            }));
            httpStatusCodes.put(apiResponse.code, ResponseObjectBuilder.responseObject().withContent(content).withDescription(apiResponse.message).withHeaders(apiResponse.responseHeaders.length == 0 ? null : Stream.of(apiResponse.responseHeaders).collect(Collectors.toMap(ResponseHeader::name, rh -> HeaderObjectBuilder.headerObject().withDescription(rh.description()).withDeprecated(rh.deprecated() ? Boolean.valueOf(true) : null).withExample(Mutils.nullOrEmpty(rh.example()) ? null : rh.example()).build()))).build());
        }
        MediaType requestBodyMediaType = this.effectiveConsumes.get(0);
        String requestBodyMimeType = requestBodyMediaType.toString();
        RequestBodyObject requestBody = this.params.stream().filter(p -> p instanceof ResourceMethodParam.MessageBodyParam).map(ResourceMethodParam.MessageBodyParam.class::cast).map(messageBodyParam -> {
            Type bodyParameterizedType;
            Class<?> bodyType = messageBodyParam.parameterHandle.getType();
            SchemaReference schemaReference = SchemaReference.find(customSchemas, bodyType, bodyParameterizedType = messageBodyParam.parameterHandle.getParameterizedType());
            SchemaObjectBuilder builder = schemaReference != null ? schemaReference.schema.toBuilder() : SchemaObjectBuilder.schemaObjectFrom(bodyType, bodyParameterizedType, messageBodyParam.isRequired).withTitle(messageBodyParam.descriptionData.summary).withDescription(messageBodyParam.descriptionData.description);
            return RequestBodyObjectBuilder.requestBodyObject().withContent(Collections.singletonMap(requestBodyMimeType, MediaTypeObjectBuilder.mediaTypeObject().withSchema(this.schemaObjectCustomizer.customize(builder, this.schemaContext(SchemaObjectCustomizerTarget.REQUEST_BODY, null, bodyType, bodyParameterizedType, requestBodyMediaType)).build()).withExample(messageBodyParam.descriptionData.example).build())).withDescription(messageBodyParam.descriptionData.summaryAndDescription()).withRequired(messageBodyParam.isRequired).build();
        }).findFirst().orElse(null);
        if (requestBody == null) {
            List formParams = this.params.stream().filter(p -> p instanceof ResourceMethodParam.RequestBasedParam).map(ResourceMethodParam.RequestBasedParam.class::cast).filter(p -> p.source == ResourceMethodParam.ValueSource.FORM_PARAM).collect(Collectors.toList());
            if (!formParams.isEmpty()) {
                ArrayList<String> required = new ArrayList<String>();
                requestBody = RequestBodyObjectBuilder.requestBodyObject().withContent(Collections.singletonMap(requestBodyMimeType, MediaTypeObjectBuilder.mediaTypeObject().withSchema(SchemaObjectBuilder.schemaObject().withType("object").withRequired(required).withProperties(formParams.stream().collect(Collectors.toMap(n -> n.key, n -> {
                    Type paramParameterizedType;
                    Class<?> paramType;
                    SchemaReference schemaReference;
                    if (n.isRequired) {
                        required.add(n.key);
                    }
                    SchemaObjectBuilder schemaObjectBuilder = (schemaReference = SchemaReference.find(customSchemas, paramType = n.parameterHandle.getType(), paramParameterizedType = n.parameterHandle.getParameterizedType())) != null ? schemaReference.schema.toBuilder() : SchemaObjectBuilder.schemaObjectFrom(paramType, paramParameterizedType, n.isRequired);
                    schemaObjectBuilder.withDeprecated(n.isDeprecated ? Boolean.valueOf(true) : null);
                    if (n.hasExplicitDefault()) {
                        schemaObjectBuilder.withDefaultValue(n.defaultValue());
                    }
                    if (n.descriptionData != null) {
                        String desc = n.descriptionData.summaryAndDescription();
                        schemaObjectBuilder.withExample(n.descriptionData.example).withDescription(n.key.equals(desc) ? null : desc);
                    }
                    return this.schemaObjectCustomizer.customize(schemaObjectBuilder, this.schemaContext(SchemaObjectCustomizerTarget.FORM_PARAM, n.key, paramType, paramParameterizedType, requestBodyMediaType)).build();
                }))).build()).build())).build();
            }
        }
        return OperationObjectBuilder.operationObject().withSummary(this.descriptionData.summary).withDescription(this.descriptionData.description).withExternalDocs(this.descriptionData.externalDocumentation).withDeprecated(this.isDeprecated ? Boolean.valueOf(true) : null).withRequestBody(requestBody).withResponses(ResponsesObjectBuilder.responsesObject().withHttpStatusCodes(httpStatusCodes).build());
    }

    private SchemaObjectCustomizerContext schemaContext(SchemaObjectCustomizerTarget target, String parameter, Class<?> type, Type parameterizedType, MediaType mediaType) {
        return new SchemaObjectCustomizerContext(target, type, parameterizedType, this.resourceClass.resourceInstance, this.methodHandle, parameter, mediaType);
    }

    private static List<ApiResponseObj> getApiResponses(java.lang.reflect.Method methodHandle) {
        ApiResponse single;
        ApiResponses apiResponses = methodHandle.getDeclaredAnnotation(ApiResponses.class);
        ArrayList<ApiResponseObj> result = new ArrayList<ApiResponseObj>();
        if (apiResponses != null) {
            for (ApiResponse ar : apiResponses.value()) {
                result.add(ApiResponseObj.fromAnnotation(ar, methodHandle));
            }
        }
        if ((single = methodHandle.getDeclaredAnnotation(ApiResponse.class)) != null) {
            result.add(ApiResponseObj.fromAnnotation(single, methodHandle));
        }
        if (result.isEmpty()) {
            Class<?> returnType = methodHandle.getReturnType();
            Type genericReturnType = methodHandle.getGenericReturnType();
            String code = Void.TYPE.isAssignableFrom(returnType) ? "204" : "200";
            result.add(new ApiResponseObj(code, "Success", new ResponseHeader[0], returnType, genericReturnType, new String[0], null));
        }
        return result;
    }

    static Method getMuMethod(java.lang.reflect.Method restMethod) {
        Annotation[] annotations = restMethod.getAnnotations();
        Method value = null;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> anno = annotation.annotationType();
            HttpMethod httpMethodAnno = anno.getAnnotation(HttpMethod.class);
            if (httpMethodAnno == null) continue;
            if (value != null) {
                throw new IllegalArgumentException("The method " + restMethod + " has multiple HttpMethod annotations. Only one is allowed per method.");
            }
            value = Method.valueOf(httpMethodAnno.value());
        }
        return value;
    }

    public String toString() {
        return "ResourceMethod{" + this.resourceClass.resourceClassName() + "#" + this.methodHandle.getName() + "}";
    }

    boolean canProduceFor(List<MediaType> clientAccepts) {
        return MediaTypeHeaderDelegate.atLeastOneCompatible(this.effectiveProduces, clientAccepts, null);
    }

    boolean canConsume(MediaType requestBodyMediaType) {
        return MediaTypeHeaderDelegate.atLeastOneCompatible(this.effectiveConsumes, Collections.singletonList(requestBodyMediaType), null);
    }
}

